/*=============================================================================

Testbench for Serial SPI Bus EEPROM Simulation Model

=============================================================================*/

`include "M95XXX_Parameters.v"

//This defines the parameter file for M95P32 process
//Any other M95xxx memory should define here the proper M95xxx parameter file

//=====================================
module M95XXX_SIM;

wire c,d,q,s,w,hold,vcc,vss;

//-------------------------------------
M95XXX U_M95XXX(
                    .C(c),
                    .D(d),
                    .Q(q),
                    .S(s),
                    .W(w),
                    .HOLD(hold),
                    .VCC(vcc),
                    .VSS(vss)
                 );
//-------------------------------------
M95XXX_DRV M95XXX_Driver(
                            .C(c),
                            .D_bidir(d),
                            .Q(q),
                            .S(s),
                            .W_bidir(w),
                            .HOLD_bidir(hold),
                            .VCC(vcc),
                            .VSS(vss)
                          );
//-------------------------------------
M95XXX_Macro_mux M95XXX_Macro_mux();

integer index;
reg [8*3:0] string;
reg [8*4:0] string2;

initial begin
   if (!`VALID_PRT) 
   begin
       $display("\n###############################################");
       $display("###      NO VAILED MEMORY SIZE CHOOSEN   ###");
       $display("##############################################\n");
       $stop;
   end     

   if (`M95_var)
	   	   string  = "M95";
   else 
           string  = "XXX";

   if (`M32Mb_var)
	   		string2 = "P32";
   else
          string2 = "XXXX";

   
   if (`VALID_PRT) 
		begin
			$display("\n\t################################################################################");
		      if (`M95_var) 
			  	begin
				  		$display("\t###     The Selected Model is an EEPROM, referenced as %3s-%3s            ###",string,string2);
						$display("\t###        with a clock period of %6.2f ns  (frequency of %5.2f MHz)        ###", M95XXX_SIM.M95XXX_Macro_mux.tC, M95XXX_SIM.M95XXX_Macro_mux.fC);
			     			if(`IDPAGE)
				     			$display("\t###   				with  ID PAGE				     ###");
			     			else
				     			$display("\t###    					  without  ID PAGE						   ###");
		        	end
		      else
			     $display("\t###    					This model is unknown 						###");
   		end
           $display("\t###     	Operating voltage selected: VCC=%1f V                   ###     ",`Vcc);


   if(`M32Mb_var)
	    $display("\t###  			    Memory Capacity: 32 Mb                           ###");
   else begin
        $display("\n###############################################");
        $display("###      NO VAILED MEMORY SIZE CHOOSEN   ###");
        $display("##############################################\n");
        $stop;
   end

   $display("\t################################################################################\n");


    $display("%t: NOTE: Load memory with Initial content.",$realtime);
    $readmemh("M95XXX_Initial.dat",U_M95XXX.memory);
    $display("%t: NOTE: Initial Load End.\n",$realtime);   

	$display("%t: NOTE: Load memory buffers with Initial content.",$realtime);
    $readmemh("M95XXX_Initial_buffers.dat",U_M95XXX.mem_buffer);
    $display("%t: NOTE: Initial buffer Load End.\n",$realtime);   

	$display("%t: NOTE: Load SFDP register with Initial content.",$realtime);
    $readmemh("M95XXX_SFDP.dat",U_M95XXX.sfdp_register);
    $display("%t: NOTE: SFDP register Load End.\n",$realtime); 

    if (`IDPAGE)
    begin
      $display("%t: NOTE: Load ID memory with Initial content.",$realtime);
      $readmemh("M95XXX_ID_Initial.dat",U_M95XXX.memory_id);
      $display("%t: NOTE: Initial ID Load End.\n",$realtime);
    end
end


//-------------------------------------

endmodule
