/*=======================================================================================

 Parameters Definition for M95xxx process Behavioral Model

=========================================================================================

 This program is provided "as is" without warranty of any kind, either
 expressed or implied, including but not limited to, the implied warranty
 of merchantability and fitness for a particular purpose. The entire risk
 as to the quality and performance of the program is with you. Should the
 program prove defective, you assume the cost of all necessary servicing,
 repair or correction.
 
 Copyright 2001, 2018, STMicroelectronics Corporation, All Right Reserved.

=======================================================================================*/

`timescale 1ns/1ps

//////////////////////////////////////////////
`define DATA_BITS           8

`ifdef M32Mb
   `define VALID_PRT           1               //Valid Part
   `define MEM_SIZE            4194304          //32M bits = 4194304 bytes
   `define MEM_ADDR_BITS       22              //memory address bits //22 because there are 4194304 bytes to address
   `define PAGE_ADDR_BITS      13              //page address bits //13 because there are 8192 page to address 
   `define PAGES               8192           //8192 pages
   `define PAGE_SIZE           512             //512 bytes in each page
   `define PAGE_OFFSET_BITS    9              //each 512 bit (2^9 bit) change page  
`else
   `define VALID_PRT           0               //Valid Part
   `define MEM_SIZE            65536           //512K bits = 65536 bytes
   `define MEM_ADDR_BITS       16              //memory address bits
   `define PAGE_ADDR_BITS      9               //page address bits
   `define PAGES               512             //512 pages
   `define PAGE_SIZE           128             //128 bytes in each page
   `define PAGE_OFFSET_BITS    7               
`endif  


`ifdef M32Mb
   `define M32Mb_var              1
   `define M95_var				  1
`else
   `define M32Mb_var              0
   `define M95_var				  0
`endif  



`ifdef ID
	`define IDPAGE           1
`else
   `define IDPAGE           0
`endif

