`include "M95XXX_Parameters.v"
`define TC 12.5
`define FC 80.0

module M95XXX_Macro_mux;
real fC        =          5.0    ;
real tC        =          200.0  ;
real tC_slow   =          200.0  ; //Frequency for READ and RDID instructions
real tSLCH     =          60   ;
real tSHCH     =          60   ;
real tSHSL     =          90   ;
real tCHSH     =          60   ;
real tCHSL     =          60   ;
real tCH       =          80   ;
real tCL       =          80   ;
real tDVCH     =          20   ;
real tCHDX     =          20   ;
real tHHCH     =          60   ;
real tHLCH     =          60   ;
real tCLHL     =          0    ;
real tCLHH     =          0    ;
real tSHQZ     =          80   ;
real tCLQV     =          80   ;
real tCLQX     =          0    ;
real tHHQV     =          80   ;
real tHLQZ     =          80   ;
real tPW       =          4.5e6  ; // Official: Change 5 to 4.5ms
real tPP       =	  1.5e6  ; // Official: Change 5 to 1.5ms
real tWSCR     = 	  9e6  ; // Official: Change 5 to 9ms

real tPE       =          4.5e6 ;          //Page erase cycle time(512 bytes) - Official: Change 2.5 to 4.5ms 
real tSE       =          5e6   ;          //Sector erase cycle time	- Official: Change 4 to 5ms 
real tBE       =          8e6   ;          //Block erase cycle time - Official: Change 5 to 8ms 
real tCE       =          25e6  ;          //Chip erase cycle time 
real tVSL      =          30e3  ;          //POWER-UP --> VCC(min) to ~S low
real tPWD      =          10e3  ;          //POWER-DOWN Time for Reset
real tRST1     =          30e3  ;          //Reset Time when reset occurs with WIP=0
real tRST2     =          12e6   ;          //Reset Time when reset occurs in modify operation except chip erase - Official: Change 8 to 12ms 
real tRST3     =          25e6  ;          //Reset Time when reset occurs in chip erase execution
real tRDPD     =          30e3  ;          // Release Deep power-down delay to ~S low
real tDP       =          10e3  ;          //Time Delay for Deep power-down mode after ~S high
real tRDPSL    =          10e3  ;          //Delay for ~S low (new instruction) after ~S high from Deep power-down instruction
real tHHQX     =          1     ;           //!Hold high to output low/high-Z (Load 30pF)
real tWHSL     =          10    ;           //WRITE PROTECT setup time
real tSHWL     =          10    ;           //WRITE PROTECT hold time
real tCLCH     =          29    ;           //// Clock rise time 0.1(V/ns)
real tCHCL     =          29    ;           ////Clock fall time 0.1(V/ns)

real tH_CLK    =          100.0 ;
real tL_CLK    =          100.0 ;

real tH_CLK_slow =        100.0 ;
real tL_CLK_slow =	  100.0 ;


initial begin

 if (`M95_var) 
	begin
		if ( `Vcc >= 1.6 && `Vcc <= 2.6 ) 
			begin
		 		if ( `M32Mb_var && `FC <= 40.0 )
				begin
					$display("\n\n======================================\n Vcc = %g , Max working frequency is 40MHz \n====================================== ",`Vcc);
			 		table_40MHz;
				end
				else if (`FC > 40.0) begin
					$display("\n\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************");
					$display(" *************************************************************************************************************************\n *******************                                     ERROR                                **************************** \n");
					$display(" ************ With this Vcc, Max Working Frequence (Fc) is 40MHz, Clock Frequency inserted is %g MHz ****************",1000.0/(`TC));
					$display(" \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n");
					table_40MHz;
					//$finish;
				end
		 		else
				$display("No AC Table exists for this Vcc selection = ^1fV",`Vcc);
			end
		else if ( `Vcc > 2.6 && `Vcc <= 3.6 )
			begin
		 		if ( `M32Mb_var && `FC <= 80.0 )
				begin
					$display("\n\n======================================\n  Vcc = %g , Max working frequency is 80MHz \n====================================== ",`Vcc);
			 		table_80MHz;
				end
				else if (`FC > 80.0) begin
					$display("\n\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************");
					$display(" *************************************************************************************************************************\n *******************                                     ERROR                                **************************** \n");
					$display(" ************ With this Vcc, Max Working Frequence (Fc) is 80MHz, Clock Frequency inserted is %g MHz ****************",1000.0/(`TC));
					$display(" \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n \t\t\t\t\t*************************************\n");
					table_80MHz;
					//$finish;
				end
		 		else
					$display("No AC Table exists for this Vcc selection = ^1fV",`Vcc);
			end
		else begin
			$display(" ************ ERROR - This Vcc is out of scope - Simulation stops ****************");
			$finish;
		end
 	end
 
 else 
  	begin
     		$display("No AC Table exists for this Vcc selection = %1fV", `Vcc);
   	end

 tH_CLK    =          tC/2.0 ; 
 tL_CLK    =          tC/2.0 ;

 tH_CLK_slow    =          tC_slow/2.0 ; 
 tL_CLK_slow    =          tC_slow/2.0 ;


/*
#1e7; 
tC = 35.0;
 tH_CLK    =          tC/2.0 ; 
 tL_CLK    =          tC/2.0 ;

#1e7; 
tC = 25.0;
 tH_CLK    =          tC/2.0 ; 
 tL_CLK    =          tC/2.0 ;

#1e7; 
tC = 10.0;
 tH_CLK    =          tC/2.0 ; 
 tL_CLK    =          tC/2.0 ;
*/
end //initial

task table_40MHz; //tavola per EEPROM M95P32 
	begin
//	 fC        =        1000.0/(`TC); //  40 max   ;           //40MHz_1
	 fC        =        (`FC); //  40 max   ;           //40MHz_1

//        tC        =         (`TC); //12.5   ;           // ns
        tC        =         1000.0/(`FC); //12.5   ;           // ns

	if (tC < 25.0) begin

	tC_slow = 25.0;
	$display("==========================================================================================");
	$display("ERROR: fC is %g MHz > 40 MHz This is out of range because Vcc is under 2.6V ", 1000.0/(`TC));
	$display("==========================================================================================");

	end
	else begin
	tC_slow = tC; 
	end

	tSLCH     =          5    ;           ///S Active Setup Time
        tSHCH     =          3    ;           ///S Not Active Setup Time
        tSHSL     =          50   ;           ///S Deselect Time
        tCHSH     =          5    ;           ///S Active Hold Time
        tCHSL     =          5    ;           ///S Not Active Hold Time
        tCH       =          10  ;
        tCL       =          10  ;
	tCLCH	  = 	     0.1  ;
	tCHCL	  =	     0.1  ;
        tDVCH     =          2    ;           //Data In Setup time
        tCHDX     =          2    ;           //Data In Hold time
        tHHCH     =          5    ;
        tHLCH     =          5    ;
        tCLHL     =          0    ;
        tCLHH     =          0    ;
        tSHQZ     =          8    ;
        tCLQV     =          20   ;
        tCLQX     =          1    ;
        tHHQV     =          25   ; // Official: Change 20 to 25ms
        tHLQZ     =          8    ;
        tPW       =          4.5e6  ;             //Write Time:4ms // Official: Change 4 to 4.5ms
        tPP	      =	         1.5e6;			//Page program cycle time: 1.5ms  
        tWSCR     =	         9e6 ; // Official: Change 8 to 9ms
		tHHQX     =          1; ///Hold high to output low / Hi-Z (AGGIUNTO ADESSO)
		tWHSL     =          10;//Write Protect setup time (AGGIUNTO ADESSO)
		tSHWL     =          10;//Write Protect hold time (AGGIUNTO ADESSO)
		
	    tPE       =          4.5e6;          //Page erase cycle time(512 bytes) // Official: Change 2.5 to 4.5ms
        tSE       =          5e6;          //Sector erase cycle time // Official: Change 3 to 5ms
        tBE       =          8e6;          //Block erase cycle time // Official: Change 5 to 8ms
        tCE       =          25e6 ;          //Chip erase cycle time 

        tVSL      =          30e3 ;          //POWER-UP --> VCC(min) to ~S low     //non modificato
        tPWD      =          10e3 ;          //POWER-DOWN Time for Reset		//non modificato

        tRST1     =          30e3 ;          //Reset Time when reset occurs with WIP=0	//non modificato
        tRST2     =          12e6  ;          //Reset Time when reset occurs in modify operation except chip erase	//non modificato
        tRST3     =          25e6 ;          //Reset Time when reset occurs in chip erase execution		//non modificato

        tRDPD     =          30e3 ;          // Release Deep power-down delay to ~S low		//non modificato
        tDP       =          10e3 ;          //Time Delay for Deep power-down mode after ~S high	//non modificato
        tRDPSL    =          10e3 ;          //Delay for ~S low (new instruction) after ~S high from Deep power-down instruction	//non modificato

	end
endtask

task table_80MHz; //tavola per EEPROM M95P32 
	begin
	    fC        =        1000.0/(`TC); //  80   ;           //80MHz_1
        tC        =         (`TC); //12.5   ;           // ns

	if (tC < 20.0) begin

	tC_slow = 20.0;
	$display("==========================================================================================");
	$display("WARNING: fC is %g MHz > 50 MHz then the working frequency for READ and RDID will be %g MHz", 1000.0/(`TC), 1000.0/(tC_slow));
	$display("==========================================================================================");

	end
	else begin
	tC_slow = tC; 
	end

	    tSLCH     =          5    ;           ///S Active Setup Time
        tSHCH     =          3    ;           ///S Not Active Setup Time
        tSHSL     =          50   ;           ///S Deselect Time
        tCHSH     =          5    ;           ///S Active Hold Time
        tCHSL     =          5    ;           ///S Not Active Hold Time
        tCH       =          5.5  ;
        tCL       =          5.5  ;
	tCLCH	  = 	     0.1  ;
	tCHCL	  =	     0.1  ;
        tDVCH     =          2    ;           //Data In Setup time
        tCHDX     =          2    ;           //Data In Hold time
        tHHCH     =          5    ;
        tHLCH     =          5    ;
        tCLHL     =          0    ;
        tCLHH     =          0    ;
        tSHQZ     =          8    ;
        tCLQV     =          11   ; // Official: Change 10 to 11ms
        tCLQX     =          1    ;
        tHHQV     =          15   ; // Official: Change 10 to 15ms
        tHLQZ     =          8    ;
        tPW       =          4.5e6  ;             //Write Time:4ms // Official: Change 4 to 4.5ms
        tPP	      =	         1.5e6;			//Page program cycle time: 1.5ms  
        tWSCR     =	         9e6 ; // Official: Change 8 to 9ms
		tHHQX     =          1; ///Hold high to output low / Hi-Z (AGGIUNTO ADESSO)
		tWHSL     =          10;//Write Protect setup time (AGGIUNTO ADESSO)
		tSHWL     =          10;//Write Protect hold time (AGGIUNTO ADESSO)
		
	    tPE       =          4.5e6;          //Page erase cycle time(512 bytes) // Official: Change 2.5 to 4.5ms
        tSE       =          5e6;          //Sector erase cycle time // Official: Change 3 to 5ms
        tBE       =          8e6;          //Block erase cycle time // Official: Change 5 to 8ms
        tCE       =          25e6 ;          //Chip erase cycle time 

        tVSL      =          30e3 ;          //POWER-UP --> VCC(min) to ~S low     //non modificato
        tPWD      =          10e3 ;          //POWER-DOWN Time for Reset		//non modificato

        tRST1     =          30e3 ;          //Reset Time when reset occurs with WIP=0	//non modificato
        tRST2     =          12e6  ;          //Reset Time when reset occurs in modify operation except chip erase	//non modificato
        tRST3     =          25e6 ;          //Reset Time when reset occurs in chip erase execution		//non modificato

        tRDPD     =          30e3 ;          // Release Deep power-down delay to ~S low		//non modificato
        tDP       =          10e3 ;          //Time Delay for Deep power-down mode after ~S high	//non modificato
        tRDPSL    =          10e3 ;          //Delay for ~S low (new instruction) after ~S high from Deep power-down instruction	//non modificato

	end
endtask
endmodule
