/*=============================================================================

  M95XXX Serial SPI EEPROM Driver

=============================================================================*/

`include "M95XXX_Parameters.v"

//This defines the parameter file for M95P32 process
//Any other M95xxx memory should define here the proper M95xxx parameter file

//`define     tH_CLK      `tC/2
//`define     tL_CLK      `tC/2

//=====================================
module M95XXX_DRV(
                    C,
                    D_bidir,
                    Q,
                    S,
                    W_bidir,
                    HOLD_bidir,
                    VCC,
                    VSS
                  );

//-------------------------------------
input Q;
inout D_bidir,W_bidir,HOLD_bidir;
output C,S,VCC,VSS;
	
//pragma protect 
//pragma protect begin
//
//-------------------------------------
real time_wait;
real time_instruc_end;
real time_instruc_start;
integer x;

integer i,j,n;
integer i1=0;
integer add_bytes,instructionA8;

reg C,S,VCC,VSS; 
reg[7:0] sr,read_dat;
reg[7:0] data;
reg[3*8-1:0] d_address,jedec_data;
reg[2*8-1:0] config_safe_data;
reg[7:0] vr; 
reg[7:0]volatile_data;
reg[7:0]read_sfdp;
reg [15:0]status_conf_reg;

reg FDREAD = 0;
reg FQREAD = 0;
reg FQREAD_D = 0; 
reg D, W, HOLD; 
assign D_bidir = (FQREAD_D || FDREAD) ? 1'bz : D ;//DQ0 : D ; //if FQREAD is disabled. D, W and HOLD are output.  
assign W_bidir = (FQREAD) ? 1'bz : W; //DQ2 : W;
assign HOLD_bidir = (FQREAD_D) ? 1'bz : HOLD;//DQ3 : HOLD;
//-------------------------------------

//pragma protect end

integer indirizzo;
initial begin
	
//pragma protect 
//pragma protect begin
        if (`MEM_ADDR_BITS <= 9)
           add_bytes = 1;
        else if (9 < `MEM_ADDR_BITS && `MEM_ADDR_BITS <= 16)
           add_bytes = 2;
        else if (16 < `MEM_ADDR_BITS && `MEM_ADDR_BITS <= 24)
           add_bytes = 3;
        else
           add_bytes = 2;

        if (`MEM_ADDR_BITS == 9)
           instructionA8 = 1;
        else
           instructionA8 = 0;
 //pragma protect end        
        VSS = 1'b0;
        VCC = 1'b1;
        #100;
        S = 1'b1;
        #100;
        S = 1'b0;       ///HOLD and /W are not driven before this instruction. Model will warn to user.
        #100;
        
        VCC = 1'b0;
        #100;
        VCC = 1'b1;
        #100;
        S = 1'b1;
        W = 1'b1;       ///W is driven high
        HOLD = 1'b1;    ///HOLD is driven high
        #100;



        //---------------------------------------
        $display("======================================================================");
        $display("==  TESTING1: READ/WRITE STATUS REGISTER INSTRUCTION VERIFICATION.  ==");
        $display("======================================================================");
        W = 1;
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b1111_1111);//01
        READ_STATUS_REGISTER;   //should be "0000_0011"
        //bit0(WIP) is "1" during the WRSR cycle. bit1(WEL) is "1". bit 4,5,6 are always "0"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be "1000_1100"
        //bit0(WIP) is "0" and bit1(WEL) is reset when WRSR cycle is completed. 
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(2,{8'b0000_0000,8'b0000_0000});//01
        READ_STATUS_REGISTER;   //should be "1000_1111"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be "0000_0000"
        READ_CONFIG_SAFE_REG;//15

        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(3, {8'b1111_0000, 8'b1010_1010}); //should be error, because write Status_Config register can write 2 bytes at maximum
        READ_STATUS_REGISTER;   //should be "0000_0011"
        READ_CONFIG_SAFE_REG;//15
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //05
        READ_CONFIG_SAFE_REG;//15

        W = 0;
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b1111_1111);//01
        READ_STATUS_REGISTER;   //should be "0000_0011"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be  "1101_1100"

        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);//01
        //W = 0, SRWD = 1, enter "HPM" this "WRSR" instruction is not executed and self-time WRSR cycle is not initiated.
        READ_STATUS_REGISTER;   //should be "1000_1110"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be "1000_1110"

        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0011);//01
        READ_STATUS_REGISTER;   //should be "1000_1110"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be "1000_1110"

        W = 1;
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0011);//01
        READ_STATUS_REGISTER;   //should be "1000_1111"
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;   //should be "0000_0000"
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        //---------------------------------------
	$display("=======================================================");
	$display("==  TESTING2: MEMORY ARRAY READ/WRITE VERIFICATION.  ==");
	$display("=======================================================");
    
        W = 1;
	$display("=======================================");
	$display("==========READ_CONFIG_SAFE_REG=========");
	$display("=======================================");
        READ_CONFIG_SAFE_REG;//15
	$display("=======================================");
	$display("=======END READ_CONFIG_SAFE_REG========");
	$display("=======================================");


	$display("======================================================================");
	$display("=TESTING: Read, Fast Read, Fast Dual Read, Fast Quad Read instruction=");
	$display("======================================================================");
        READ_DATA_BYTES(10, 'h3ffff9); //10 byte from 3FFFF9
       
       	WRITE_ENABLE;  //Writing Address 00000 with data AA 
	$display("%t DRIVER: Writing AA in address 0",$realtime); 
	PAGE_PROGRAM_IN(1,8'hAA,{`MEM_ADDR_BITS {1'b0}}); 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);
        READ_DATA_BYTES(2,{`MEM_ADDR_BITS {1'b1}});
	
	$display("====================================================");
	$display("=============READ===================================");
	$display("====================================================");
	READ_DATA_BYTES(10, 'h3ffff9);
	$display("====================================================");
	$display("==========END READ==================================");
	$display("====================================================");
	
	
	$display("=============FAST READ==============================");
	$display("====================================================");
	FAST_READ_DATA_BYTES(10, 'h3ffff9);
	$display("====================================================");
	$display("==========END FAST READ=============================");
	$display("====================================================");
	
	$display("====================================================");
	$display("=============FAST DUAL READ=========================");
	$display("====================================================");
	FD_READ_DATA_BYTES(10, 'h3ffff9);
	$display("====================================================");
	$display("==========END FAST DUAL READ========================");
	$display("====================================================");
	

	$display("====================================================");
	$display("=============FAST QUAD READ=========================");
	$display("====================================================");
	FQ_READ_DATA_BYTES(10, 'h3ffff9);
	$display("====================================================");
	$display("==========END FAST QUAD READ========================");
	$display("====================================================");
    
   
	$display("====================================================");
	$display("=============READ ID PAGE===========================");
	$display("====================================================");
    	READ_ID_PAGE(10,{`MEM_ADDR_BITS {1'b0}});
    	READ_ID_PAGE(200,'h0200);
    	READ_ID_PAGE(1030,'h0);
    	READ_ID_PAGE(50,'h0500);
	$display("====================================================");
	$display("==========END READ ID PAGE==========================");
	$display("====================================================");
    
	$display("====================================================");
	$display("=============FAST READ ID PAGE======================");
	$display("====================================================");
	FAST_READ_ID(10, 'h00);
        FAST_READ_ID(10, 'h3fc);
        FAST_READ_ID(10, 'h467); //should give error because exceed memory dimension
	$display("====================================================");
	$display("==========END FAST READ ID PAGE=====================");
	$display("====================================================");

  	FQ_READ_DATA_BYTES(10, 'h3ffff9);
	READ_STATUS_REGISTER;//05
	WRITE_ENABLE;//06
	READ_STATUS_REGISTER;   
	PAGE_ERASE('h00);
	#(M95XXX_SIM.M95XXX_Macro_mux.tPE);
	FQ_READ_DATA_BYTES(10, 'h3ffff9);

 	
	$display("====================================================");
	$display("=============READ AND WRITE VOLATILE================");
	$display("===================================================="); 
        READ_VOLATILE_REG;
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h02); //81
        READ_VOLATILE_REG; //85
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h00); //81
        READ_VOLATILE_REG; //85
	$display("====================================================");
	$display("==========END READ AND WRITE VOLATILE===============");
	$display("====================================================");
	
	$display("====================================================");
	$display("============= PAGE PROGRAM =========================");
	$display("====================================================");
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(5,8'h0F,{`MEM_ADDR_BITS {1'b1}});  //writing 0F in 5 bytes. Addresses from 3FFFFF 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG; //15 //read safe register at the end of page program cycle 
	READ_DATA_BYTES(512,`MEM_ADDR_BITS'h3ffe00);
	FQ_READ_DATA_BYTES(512,`MEM_ADDR_BITS'h3ffe00);

	$display("=============================================");
	$display("==PAGE PROGRAM on already WRITTEN Addresses==");
	$display("=============================================");
	WRITE_ENABLE;//06
	$display("%t DRIVER: PAGE PROGRAM SENDING on already WRITTEN Addresses",$realtime); 
	PAGE_PROGRAM_IN(100,8'hAA,{`MEM_ADDR_BITS {1'b1}}); //would give error, writing AA in 100 bytes written in the previous program page
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
        READ_CONFIG_SAFE_REG; //15//would show a PRF = 1 and an error
        
    		
	$display("%t ===============================================",$realtime);
	$display("%t =======CLEAR SAFETY REGISTER SENDING=========== ",$realtime);	
	$display("%t ===============================================",$realtime);
	CLEAR_SAFETY_STI_FLAGS; //Clear the safety register //50
	READ_CONFIG_SAFE_REG;//would show a 00h safety register
	READ_STATUS_REGISTER; //05
	FQ_READ_DATA_BYTES(512,`MEM_ADDR_BITS'h3ffe00); //would show the old data 0F, written in the previous page program
	
	READ_STATUS_REGISTER; //05
	WRITE_ENABLE;   //06    
	SECTOR_ERASE('h3FFFF0); //erasing the address already written.
	#(M95XXX_SIM.M95XXX_Macro_mux.tSE);
        READ_CONFIG_SAFE_REG;//15
        FQ_READ_DATA_BYTES(`PAGE_SIZE+2,{`MEM_ADDR_BITS {1'b1}}-`PAGE_SIZE);//reads 514 bytes

      
	$display("==========================================");
	$display("============= PAGE PROGRAM WRITING ===============");
	$display("==========================================");
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h0F,{`MEM_ADDR_BITS {1'b0}});  //writing 0F in 512 bytes. Addresses from 000000 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
									
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h1F, 'h200);  //writing 1F in 512 bytes. Addresses from 000200 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
								
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h2F, 'h430);  //writing 2F in 512 bytes. Addresses from 000430 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
		
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h3F, 'h645);  //writing 3F in 512 bytes. Addresses from 0006FF 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
		
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h4F, 'h800);  //writing 4F in 512 bytes. Addresses from 0008FF 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
		
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,8'h5A, 'hA00);  //writing 5A in 512 bytes. Addresses from 000A00 
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
       	READ_CONFIG_SAFE_REG;//15
        FD_READ_DATA_BYTES(2560,'h000);
	FQ_READ_DATA_BYTES(2560,'h000);
		
	$display("%t =============================\nMEMORY END of 4 PAGE PROGRAM \n Erasing the memory\n============================",$realtime);
	
	WRITE_ENABLE;//06
	SECTOR_ERASE('h000);
	#(M95XXX_SIM.M95XXX_Macro_mux.tSE);
	FQ_READ_DATA_BYTES(2560,'h000);
        READ_VOLATILE_REG;//85  
	WRITE_ENABLE;//06
		
        $display("============================================================================");
        $display("%t========= DRIVER: Enabling BUFFER MODE  ================",$realtime);
	$display("============================================================================");
        WRITE_VOLATILE_REG('h02);  //81
        READ_VOLATILE_REG;//85
        READ_CONFIG_SAFE_REG;//15

        $display("==========================================================");
	$display("============= PAGE PROGRAM BUFFER WRITING  ===============");
	$display("==========================================================");
        WRITE_ENABLE;//06

	for (x=0; x<6 ; x = x+1) //8192 max
		begin
			time_instruc_start = $realtime();
			if (x == 0)
				PAGE_PROGRAM_IN(512, 0 , 0);
			else if (x == 5)
			begin
				READ_CONFIG_SAFE_REG; //15    
				PAGE_PROGRAM_IN(512,x, 512*x); //WIP 1 BUFLD 1 
				time_instruc_end = $realtime();
				time_wait = time_instruc_end - time_instruc_start ;
				//$display("DRIVER DEBUG: the following should give error");
				PAGE_PROGRAM_IN(512,x+1, 512*(x+1)); //should give Error because the memory is busy and buffer is full! 
				//$display("DRIVER DEBUG: ERROR");
				READ_CONFIG_SAFE_REG; //15
			        CLEAR_SAFETY_STI_FLAGS;//50
			        READ_CONFIG_SAFE_REG; //15
			        #((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait); 
			end
			else if ( (x%256) == 255 )
			begin
				READ_CONFIG_SAFE_REG;
				PAGE_PROGRAM_IN(512, 170 , 512*x);
				time_instruc_end = $realtime();
				time_wait = time_instruc_end - time_instruc_start ;
				if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
					#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait); 
				//#(M95XXX_SIM.M95XXX_Macro_mux.tPP); 
			end
			else
			begin
				READ_CONFIG_SAFE_REG;
				PAGE_PROGRAM_IN(512, x , 512*x); //500+(x%12)
				time_instruc_end = $realtime();
				time_wait = time_instruc_end - time_instruc_start ;
				if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
					#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait); 
				//#(M95XXX_SIM.M95XXX_Macro_mux.tPP); 
			end
		end
 
	READ_CONFIG_SAFE_REG; //15
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);

        $display("%t ==============================================",$realtime);
        $display("%t ======= Finish writing in buffer mode ========",$realtime);
        $display("%t ==============================================",$realtime);
        
       	READ_CONFIG_SAFE_REG; //15
		
	
	$display("\n\n\n==========================================");
	$display("======= DISABLING BUFFER MODE=============");
        $display("==========================================");
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h01); //81     
        READ_VOLATILE_REG; //85
        READ_CONFIG_SAFE_REG; //15
        FQ_READ_DATA_BYTES(512*6,'h000);
//        FQ_READ_DATA_BYTES(512*4, 512*254);	
//        FQ_READ_DATA_BYTES(512*4, (512*256*3)-(512*2));
//        FQ_READ_DATA_BYTES(512*4, (512*256*10)-(512*2));

	WRITE_ENABLE;//06
        CHIP_ERASE; //C7   
        #(M95XXX_SIM.M95XXX_Macro_mux.tCE);
        READ_CONFIG_SAFE_REG; //15
	CLEAR_SAFETY_STI_FLAGS;//50
      

        $display("============================================================================================");
	$display("============= TESTING PAGE PROGRAM BUFFER IN CASE OF PROTECTED MEMORY AREAs   ===============");
	$display("=============================================================================================");
	        
	WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0101_1000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;//05 
        
        WRITE_ENABLE;//06
        $display("%t=========\n DRIVER: Enabling BUFFER MODE  \n ================",$realtime);
        WRITE_VOLATILE_REG('h02);  //81
        READ_VOLATILE_REG;//85
        READ_CONFIG_SAFE_REG;//15

        $display("===========================================================================");
        $display("============= PAGE PROGRAM BUFFER WRITING IN PROTECTED AREA ===============");
	$display("===========================================================================");

        WRITE_ENABLE;//06

        PAGE_PROGRAM_IN(512,8'h0F, 'h200000);

	time_instruc_start = $realtime(); 
        READ_CONFIG_SAFE_REG;//15
	PAGE_PROGRAM_IN(512,8'h1F, 'h200); //fail because memory area protected
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);
//	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);

	time_instruc_start = $realtime();
        READ_CONFIG_SAFE_REG;  //15
        CLEAR_SAFETY_STI_FLAGS;//50
	READ_CONFIG_SAFE_REG; //15     
	PAGE_PROGRAM_IN(512,8'h2F, 'h200200); //WIP 0 BUFLD 0 //writing 
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);

	time_instruc_start = $realtime();	
        READ_CONFIG_SAFE_REG;//15
        PAGE_PROGRAM_IN(512,8'h3F, 'h200400); //WIP 1 BUFLD 0 // write in buffer
        //PAGE_PROGRAM_IN(512,8'h3F, 'h600);
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);

//	#(M95XXX_SIM.M95XXX_Macro_mux.tPP); //finish write 2f   WIP 0 

	time_instruc_start = $realtime();
	CLEAR_SAFETY_STI_FLAGS;//50
	READ_CONFIG_SAFE_REG;//15
        PAGE_PROGRAM_IN(512,8'h3F, 'h600);   //WIP 1 BUFLD 0 but should fail because memory area protected
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);

//	#(M95XXX_SIM.M95XXX_Macro_mux.tPP); //finish write 3f 

	time_instruc_start = $realtime();
        READ_CONFIG_SAFE_REG;//15
	CLEAR_SAFETY_STI_FLAGS;//50
	READ_CONFIG_SAFE_REG;//15
        
	PAGE_PROGRAM_IN(512,8'h4F, 'h800);  //WIP 0 BUFLD 0  but should fail because memory area protected
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);

//     	#(M95XXX_SIM.M95XXX_Macro_mux.tPP); 

	time_instruc_start = $realtime();
     	READ_CONFIG_SAFE_REG;//15
	CLEAR_SAFETY_STI_FLAGS;//50
       	READ_CONFIG_SAFE_REG;//15
	PAGE_PROGRAM_IN(512,8'h5F, 'hA00);  //WIP 0 BUFLD 0 but should fail because memory area protected
	time_instruc_end = $realtime();
	time_wait = time_instruc_end - time_instruc_start ;
	if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
		#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait);

//     	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
        
	READ_CONFIG_SAFE_REG;//15
        CLEAR_SAFETY_STI_FLAGS;//50
       	READ_CONFIG_SAFE_REG;//15
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);

        $display("%t ==============================================",$realtime);
        $display("%t ======= Finish writing in buffer mode ========",$realtime);
        $display("%t ==============================================",$realtime);
        
       	READ_CONFIG_SAFE_REG;//15
        
	$display("\n\n\n==========================================");
	$display("======= DISABLING BUFFER MODE==================");
        $display("================================================");
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h01); //81      
        READ_VOLATILE_REG; //85
        READ_CONFIG_SAFE_REG;//15	
        FQ_READ_DATA_BYTES(2560,'h000);
	FQ_READ_DATA_BYTES(512,'h200000);
        FQ_READ_DATA_BYTES(512,'h200200);
        FQ_READ_DATA_BYTES(512,'h200400);
        					  
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;//05

///qui
	
        $display("===============================================");
        $display("======= PAGE PROGRAM ==========================");
        $display("===============================================");
	WRITE_ENABLE;//06
        $display("%t DRIVER: PAGE PROGRAM SENDING",$realtime);
	PAGE_PROGRAM_IN(5,8'hAA,{`MEM_ADDR_BITS {1'b1}});
      	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
        READ_CONFIG_SAFE_REG;//15
	  //FQ_READ_DATA_BYTES(5,{`MEM_ADDR_BITS {1'b1}});
        FD_READ_DATA_BYTES(514,`MEM_ADDR_BITS'h3ffe00);
        FQ_READ_DATA_BYTES(514,`MEM_ADDR_BITS'h3ffe00);
   		
W=1; HOLD =1;
              
        WRITE_ENABLE;//06
//        WRITE_DATA_IN(64,`DATA_BITS'h55,`MEM_ADDR_BITS'h3ff);
        WRITE_DATA_IN(`PAGE_SIZE,`DATA_BITS'h0f,{`MEM_ADDR_BITS {1'b1}}); //writes 512 byte from 3fffff
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
//        READ_DATA_BYTES(34,`MEM_ADDR_BITS'h3df);
        READ_DATA_BYTES(`PAGE_SIZE+2,{`MEM_ADDR_BITS {1'b1}}-`PAGE_SIZE); //reads 514byte 
        FD_READ_DATA_BYTES(`PAGE_SIZE+2,{`MEM_ADDR_BITS {1'b1}}-`PAGE_SIZE);
        FQ_READ_DATA_BYTES(`PAGE_SIZE+2,{`MEM_ADDR_BITS {1'b1}}-`PAGE_SIZE);
        
	WRITE_DATA_IN(`PAGE_SIZE,`DATA_BITS'h57,{`MEM_ADDR_BITS {1'b1}});   //This Write Instruction will not be executed.
        READ_CONFIG_SAFE_REG;//15
     		
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(10,`DATA_BITS'h69, {`MEM_ADDR_BITS {1'b1}});
	#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
        READ_CONFIG_SAFE_REG;//15
	CLEAR_SAFETY_STI_FLAGS;//50
	FD_READ_DATA_BYTES(512,`MEM_ADDR_BITS'h3ffe00);
	FQ_READ_DATA_BYTES(512,`MEM_ADDR_BITS'h3ffe00);
	//#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
		
	READ_CONFIG_SAFE_REG;//15
        
        $display("=======================================================");
        $display("======= READ Safety Register LOOP 5 times =============");
        $display("=======================================================");	
	READ_CONFIG_SAFE_REG_LOOP(5);//15
        

        WRITE_ENABLE;//06
        WRITE_DATA_IN(2,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGE_SIZE-1); //writes 2 bytes 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});  //reads 512 bytes
        FD_READ_DATA_BYTES(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});  //reads 512 bytes
        FQ_READ_DATA_BYTES(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});  //reads 512 bytes
        
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
//WRITE WITH POLLING (RDSR)	
	$display("=WRITE WITH POLLING (loop on read status register)");
        WRITE_ENABLE;//06
        WRITE_DATA_IN(2,`DATA_BITS'h55,`MEM_ADDR_BITS'd`PAGE_SIZE-1);
        READ_CONFIG_SAFE_REG;//15
        POLLING_WITH_SEL_LOOP_ON_RDSR_DESEL; 		// replacing TW by polling routine #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_DATA_BYTES(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
		
//WRITE WITH POLLING (RDSR)	
	$display("=WRITE WITH POLLING (loop on select read status register deselect)");
        WRITE_ENABLE;//06
        WRITE_DATA_IN(2,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGE_SIZE-1);
        READ_CONFIG_SAFE_REG;//15
        POLLING_WITH_LOOP_ON_SEL_RDSR_DESEL; 		// replacing TW by polling routine #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_DATA_BYTES(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
		
        WRITE_ENABLE;//06

        WRITE_DATA_IN(2,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGE_SIZE-1);
        READ_CONFIG_SAFE_REG;//15
        READ_STATUS_REGISTER;   //should be "0000_0000"

#4.991e6;
        READ_STATUS_REGISTER;   //should be "0000_0000"
#500
        READ_STATUS_REGISTER;   //should be "0000_0000"
#10
        READ_STATUS_REGISTER;   //should be "0000_0000"
        READ_STATUS_REGISTER;   //should be "0000_0000"

        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
		
		
        //---------------------------------------
        $display("===================================================================================================");
        $display("==  TESTING3: ALL INSTRUCTIONS (except RDSR) ARE NOT EXECUTED WHILE WRITE CYCLE IS IN PROGRESS.  ==");
        $display("===================================================================================================");
        W = 1;
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h11,{`MEM_ADDR_BITS {1'b0}});
        WRITE_ENABLE;//06
        WRITE_DISABLE;
        WRITE_STATUS_REGISTER(1,8'b1000_0111);//01
        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b0}});
        WRITE_DATA_IN(1,`DATA_BITS'h22,{`MEM_ADDR_BITS {1'b0}});
        READ_CONFIG_SAFE_REG;//15
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
        //---------------------------------------


        $display("===================================================================================================");
        $display("==  TESTING 3A: RANDOM TESTS                                                                     ==");
        $display("===================================================================================================");
        W = 1;


       //--------------------------------------------------------
       //Enable and disable test with write data when disabled(rejected)

        WRITE_ENABLE;//06
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_DISABLE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_DATA_IN(1,`DATA_BITS'h11,{`MEM_ADDR_BITS {1'b0}}); //rejected
        READ_CONFIG_SAFE_REG;//15

        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h11,{`MEM_ADDR_BITS {1'b0}});

        WRITE_STATUS_REGISTER(1,8'b1000_0111); //rejected //01
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(4,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------

       //--------------------------------------------------------
       //Wrap around Test for write an read
        WRITE_ENABLE;//06
        WRITE_DATA_IN(3,`DATA_BITS'h55,{`MEM_ADDR_BITS {1'b1}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15

        READ_DATA_BYTES(4,{`MEM_ADDR_BITS {1'b1}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        READ_DATA_BYTES(4,{`MEM_ADDR_BITS {1'b1}}-`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
        //--------------------------------------------------------

       //--------------------------------------------------------
       //Read at the ID boundry and write beyond the boundry

        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b1}}); //read beyond the ID boundry
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'h23,{`PAGE_OFFSET_BITS {1'b1}}); //2 written byte rejected beyond the boundry
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(3,{`PAGE_OFFSET_BITS {1'b1}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
        
        //Added in v1.6
      //  $display("=========================\n WRITING in first ID PAGE\n=========================");
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'h23,24'h00C);//fail because trying to write in the first IDPAGE that is only-read mode
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(3,{`PAGE_OFFSET_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------
		//$display("=========================\n WRITING out of boundary in ID PAGE\n=========================");
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'h23,24'h40C); //fail because I'm trying to write out of the IDPage boundary
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(3,{`PAGE_OFFSET_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------
       //write and read the entire ID page

        WRITE_ENABLE;//06
        //WRITING THE WHOLE IDPAGE2 TO 0xAA 
        //$display("%t DRIVER: sending task write ID page or lock. \n sending : no_byte %d [%b], data AA, from address 200h",$realtime,{`PAGE_OFFSET_BITS {1'b1}}+1,{`PAGE_OFFSET_BITS {1'b1}}+1);
       
        WRITE_ID_PAGE({`PAGE_OFFSET_BITS {1'b1}}+1,`DATA_BITS'hAA, 24'h200);//{`PAGE_OFFSET_BITS {1'b0}}); //write the entire ID PAGE to 0xAA  //{`PAGE_OFFSET_BITS {1'b1}}+1
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        READ_ID_PAGE({`PAGE_OFFSET_BITS {1'b1}}+1,24'h200);  //read the whole ID PAGE 2
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------

       //--------------------------------------------------------
       //write and read LOCK ID STATUS
       $display("===================================================================================================");
        $display("==  TESTING LOCK ID PAGE (WRITE THE LOCKED ID PAGE)                                             ==");
        $display("===================================================================================================");
       //  $display("=========================\n Locking ID PAGE \n    and    \n Trying to Write the Locked ID PAGE\n=========================");
       WRITE_ENABLE;//06
       WRITE_STATUS_REGISTER(2,{8'b0000_0000,8'b0000_0001}); //sr - 00  conf_reg 01 (LOCK ID) MODE
       READ_STATUS_REGISTER;//05
       #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
       READ_STATUS_REGISTER;//05
       READ_CONFIG_SAFE_REG;//15
      //  M95XXX_SIM.U_M95XXX.config_reg[0] <= 1'b1; 
        WRITE_ENABLE;//06
 
        WRITE_ID_PAGE(1,`DATA_BITS'h02,`MEM_ADDR_BITS'h400); //write  ID page when it is locked
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(2,`MEM_ADDR_BITS'h400);  
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write  when it is already lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
  
//      $display("=========================\n Removing LOCK ID PAGE\n=========================");
//       WRITE_ENABLE;//06
//       WRITE_STATUS_REGISTER(2,{8'b0000_0000,8'b0000_0000}); //sr - 00  conf_reg 01
//       READ_STATUS_REGISTER;// M95XXX_SIM.U_M95XXX.config_reg[0] <= 1'b0; 
        
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(4,`DATA_BITS'hCC,`MEM_ADDR_BITS'h500);
        //WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write ID memory when it is lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        READ_CONFIG_SAFE_REG;//15
        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b1}});
        READ_ID_PAGE(2,`MEM_ADDR_BITS'h400);  
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        $display("=========================\n Removing LOCK ID PAGE\n=========================");
       WRITE_ENABLE;//06
       WRITE_STATUS_REGISTER(2,{8'b0000_0000,8'b0000_0000}); //sr - 00  conf_reg 01
       READ_STATUS_REGISTER;// M95XXX_SIM.U_M95XXX.config_reg[0] <= 1'b0; 
       //--------------------------------------------------------
       #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
       READ_STATUS_REGISTER;//05
       READ_CONFIG_SAFE_REG;//15

       //--------------------------------------------------------
       //write when memory disabled and a write polling the read status 

        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h22,{`MEM_ADDR_BITS {1'b0}});
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW/2);
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW/2);
        READ_CONFIG_SAFE_REG;//15
        READ_STATUS_REGISTER;//05

        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b0}});
        WRITE_DATA_IN(1,`DATA_BITS'h22,{`MEM_ADDR_BITS {1'b0}}); //rejected, write disabled
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------



       //--------------------------------------------------------
       //write when memory disabled and a write polling the read status,alternating clk finish on zero or one

        WRITE_ENABLE;//06
        WRITE_DATA_INh(1,`DATA_BITS'h22,{`MEM_ADDR_BITS {1'b0}});
        READ_STATUS_REGISTER;//05
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW/2);
        READ_STATUS_REGISTERh;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW/2);
        READ_CONFIG_SAFE_REG;//15
        READ_STATUS_REGISTER;//05

        READ_DATA_BYTESh(1,{`MEM_ADDR_BITS {1'b0}});
        WRITE_DATA_IN(1,`DATA_BITS'h22,{`MEM_ADDR_BITS {1'b0}}); //rejected, write disabled
        READ_STATUS_REGISTERh;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_DATA_INh(`PAGE_SIZE,`DATA_BITS'h55,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTESh(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});
        WRITE_ENABLE;//06
        WRITE_DATA_INh(`PAGE_SIZE/4,`DATA_BITS'h33,`PAGE_SIZE/2);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTESh(`PAGE_SIZE,{`MEM_ADDR_BITS {1'b0}});

        READ_DATA_BYTES(`PAGE_SIZE,{{`MEM_ADDR_BITS-2 {1'b1}},2'b00});


        WRITE_ENABLEh;
        WRITE_DATA_INh(1,`DATA_BITS'hAA,{`MEM_ADDR_BITS {1'b1}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,{`MEM_ADDR_BITS {1'b1}});
        READ_DATA_BYTESh(1,{`MEM_ADDR_BITS {1'b0}});


       //--------------------------------------------------------
       //write and read LOCK ID STATUS, alternating clk finish on zero or one

        WRITE_ENABLE;//06
        WRITE_ID_PAGEh(1,`DATA_BITS'h02,`MEM_ADDR_BITS'h400); //write lock ID, accepted cause only 1 byte sent
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(2,`MEM_ADDR_BITS'h400);  //read lock status twice
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLEh;
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write lock id when it is already lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_ENABLEh;
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write ID memory when it is lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b1}});
        READ_ID_PAGEh(2,`MEM_ADDR_BITS'h400);  //read lock status twice
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
       //--------------------------------------------------------


       //--------------------------------------------------------

        //---------------------------------------
        $display("=========================================================================");
        $display("==  TESTING4: VERIFICATION OF ADDRESS INSIDE A WRITE PROTECTED ARRAY.  ==");
        $display("=========================================================================");
        $display("------------------------------------------");
        $display("-- Note: Memory Array is not Protected. --");
        $display("------------------------------------------");
        W = 1;
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);    //No block of memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'h99,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        $display("-------------------------------------------------------");
        $display("-- Note: Upper quarter of Memory Array is Protected. --");
        $display("-------------------------------------------------------");
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0100);    //Upper quarter of memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'haa,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);


        $display("----------------------------------------------------");
        $display("-- Note: Upper half of Memory Array is Protected. --");
        $display("----------------------------------------------------");
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_1000);    //Upper half of memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hbb,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);


        $display("--------------------------------------------");
        $display("-- Note: Whole Memory Array is Protected. --");
        $display("--------------------------------------------");
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_1100);    //whole memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/2*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(2,`MEM_ADDR_BITS'd`PAGES/4*3*`PAGE_SIZE-1);
        WRITE_ENABLE;//06
        WRITE_DATA_IN(1,`DATA_BITS'hcc,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_CONFIG_SAFE_REG;//15
        READ_DATA_BYTES(1,`MEM_ADDR_BITS'd`PAGES*`PAGE_SIZE-1);
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

       
        //---------------------------------------
        if (`IDPAGE)
        begin
        //---------------------------------------
        $display("\n=====================================================");
        $display("==  TESTING5: MEMORY ID ARRAY READ/WRITE VERIFICATION.  ==");
        $display("========================================+++==========\n");
        #20000;
        W = 1;

        $display("-------------------------------------------------------------");
        $display("-- Note: Whole Memory Array is Protected --");
        $display("-------------------------------------------------------------");
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_1100);    //whole memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(1,`DATA_BITS'ha5,`MEM_ADDR_BITS'h7ff); //write lock id when it bp1,bp0 = (1,1), not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,`MEM_ADDR_BITS'h3ff); //write ID memory when it bp1,bp0 = (1,1), not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);    //whole memory is protected
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);

        $display("\n-------------------------------------------------");
        $display("-- Note: READ/WRITE MEMORY ID. --");
        $display("-------------------------------------------------");

        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b1}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'h23,{`PAGE_OFFSET_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(3,`DATA_BITS'hAA,{`PAGE_OFFSET_BITS {1'b1}}); //write the entire ID PAGE to 0xAA
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        READ_ID_PAGE(2,{`PAGE_OFFSET_BITS {1'b1}});  //read the whole ID PAGE
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);


        WRITE_ENABLE;//06
        WRITE_ID_PAGE(`PAGE_SIZE,`DATA_BITS'hAA,{`PAGE_OFFSET_BITS {1'b0}}); //write the entire ID PAGE to 0xAA
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);


        WRITE_ID_PAGE(`PAGE_SIZE,`DATA_BITS'h55,{`PAGE_OFFSET_BITS {1'b1}});   //This Write Enable Instruction will not be executed.

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write last byte in page and first byte wrap
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(5,`DATA_BITS'h13,`PAGE_OFFSET_BITS'h0A); //write starting at loc 0x13 location for 5 bytes
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        READ_ID_PAGE(`PAGE_SIZE,{`PAGE_OFFSET_BITS {1'b0}});  //read the whole ID PAGE
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        $display("-------------------------------------------------------------------------------");
        $display("-- Note: WRITE LOCK ID AND READ/WRITE MEMORY ID --");
        $display("-------------------------------------------------------------------------------");
        READ_ID_PAGE(2,`MEM_ADDR_BITS'h400);  //read lock status twice
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'h02,{`MEM_ADDR_BITS {1'b1}}); //write LOCK ID, not accepted cause more than 1 byte
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(1,`DATA_BITS'h02,`MEM_ADDR_BITS'h400); //write lock ID, accepted cause only 1 byte sent
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        READ_ID_PAGE(2,`MEM_ADDR_BITS'h400);  //read lock status twice
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write lock id when it is already lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_ENABLE;//06
        WRITE_ID_PAGE(2,`DATA_BITS'ha5,{`MEM_ADDR_BITS {1'b1}}); //write ID memory when it is lock, not accepted 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);

        end

//////==========================================================///////
//////============= HOLD CONDITION VERIFICATION ============///////
//////==========================================================///////
        $display("==============================================");
        if (`IDPAGE)
          $display("==  TESTING6: HOLD CONDITION VERIFICATION.  ==");
        else
          $display("==  TESTING5: HOLD CONDITION VERIFICATION.  ==");
        $display("==============================================");
        W = 1;
        WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        WRITE_ENABLE;//06
        //////////////////////////Write Data Instruction
        S = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
        S = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time - data in setup time
        //////////////////////////
        //************************
        HOLD = 1'b0;            //HOLD driven low when CLK=1, Pause right now
        D = 1'b0;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);            //data in setup time
        #(M95XXX_SIM.M95XXX_Macro_mux.tHLCH);              //clock low hold time after "HOLD" active
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK-50);
        HOLD = 1'b0;
        #25;
        HOLD = 1'b1;            //HOLD driven high when C=1, Resume next CLK falling edge
        #25;
        //************************
        HOLD = 1'b0;            //HOLD driven high same as CLK falling edge, Pause
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        for(i=0;i<add_bytes*8-1;i=i+1)
        begin
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
            C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        end
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        C = 1'b1;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK-40);
        HOLD = 1'b1;            //HOLD driven high when C=1, no effect
        #20;
        HOLD = 1'b0;            //HOLD driven low when C=1 no effect
        #20
        HOLD = 1'b1;            //HOLD driven high when C=1, and sometime C is driven low, Resume
        //------------------------
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCLHL);
        HOLD = 1'b0;            //HOLD driven low when C=0, hold start
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        for(i=0;i<4;i=i+1)
        begin
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
            C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        end
        HOLD = 1'b1;            //HOLD driven high when C=0, hold end
        //#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        #(M95XXX_SIM.M95XXX_Macro_mux.tHHCH);
        //------------------------
        C = 1'b1;               //D0 of instruction code, latched in
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        HOLD = 1'b0;            //HOLD driven low when C=1, next C falling edge start
        for(i=0;i<4;i=i+1)
        begin
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
            C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
            C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        end
        HOLD = 1'b1;            //HOLD driven high when C=1, next falling edge stop
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //------------------------
       $display("%t ********************************************************************* ",$realtime);
       $display("%t ---Write Memory Instruction code with a changing /HOLD signal --- ",$realtime);
       $display("%t ********************************************************************* ",$realtime);

        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        //D = 1'b0;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);            //data setup time
        //C = 1'b1;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        //C = 1'b0;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);              //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        //----------------------//indicate destination address
       $display("%t DRIVER: Sending ADDRESS",$realtime);
        d_address = {`MEM_ADDR_BITS {1'b0}};
        for(i=0;i<=add_bytes*8-1;i=i+1)               
        begin                              
            D = d_address[add_bytes*8-1-i];             
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
            C = 1'b1;                      
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        end

       $display("%t DRIVER: Sending DATA",$realtime);
        //----------------------//write data
        n = 32;                 //the number of data bytes
        data = 8'h29;           //indicate data value
        for(i=0;i<=n-1;i=i+1)
        begin
            for(j=0;j<=7;j=j+1)
            begin
                D = data[7-j];
                #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);      //data setup time
                C = 1'b1;
                #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
                C = 1'b0;
                #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
            end
        end
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //----------------------
        #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
        S = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        //----------------------//Write Instruction Over
//$display("DEBUG READING ...... ");
        READ_DATA_BYTES_HD(16,1'b0,{`MEM_ADDR_BITS {1'b0}});
        #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);

        $display("-------------------------------------------------------------------------------");
        $display("-- Note: READ MEMORY ID WITH HOLDS --");
        $display("-------------------------------------------------------------------------------");

        if (`IDPAGE) begin
          READ_DATA_BYTES_HD(16,1'b1,{`MEM_ADDR_BITS {1'b0}});
          #(M95XXX_SIM.M95XXX_Macro_mux.tSHQZ);
        end
      
       $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING8: JEDEC IDENTIFICATION VERIFICATION.  ==");
        else
          $display("==  TESTING7: JEDEC IDENTIFICATION VERIFICATION.  ==");

        $display("======================================================");
      
       // #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        W=1;
        JEDID;
       // #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        $display("%t DRIVER: JEDID LOOP STARTING ",$realtime);
        JEDID_LOOP(3);
        //#(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
         $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING10: CLEAR SAFETY REGISTER (CLRSF) VERIFICATION.  ==");
        else
          $display("==  TESTING9: CLEAR SAFETY REGISTER (CLRSF) VERIFICATION.  ==");

        $display("======================================================");
      
       // #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        W=1;
		  CLEAR_SAFETY_STI_FLAGS;//50
		//#(M95XXX_SIM.M95XXX_Macro_mux.tPW);//da rimuovere
        READ_CONFIG_SAFE_REG;//15
       //	#(M95XXX_SIM.M95XXX_Macro_mux.tPW);
       
/////----------------------------////////////
///----------- SECTOR ERASE (SCER) INSTRUCTION
/////----------------------------//////////// 

        $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING11: SECTOR ERASE (SCER) VERIFICATION.  ==");
        else
          $display("==  TESTING10: SECTOR ERASE (SCER) VERIFICATION.  ==");

        $display("======================================================");
      
        W=1;
          
          WRITE_ENABLE;//06
          WRITE_STATUS_REGISTER(1,8'b01011000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
          READ_STATUS_REGISTER;//05
        
		WRITE_ENABLE;//06
		 SECTOR_ERASE('hd4796); /////ERROR : TEMPT TO MODIFY A PROTECTED MEMORY AREA
		#(M95XXX_SIM.M95XXX_Macro_mux.tSE);
		READ_CONFIG_SAFE_REG;//15
		CLEAR_SAFETY_STI_FLAGS;//50
        
		WRITE_ENABLE;//06
        WRITE_STATUS_REGISTER(1,8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
        READ_STATUS_REGISTER;//05
        SECTOR_ERASE('h6000); //////// ERROR : WRITE ENABLE IS NOT DRIVEN
		#(M95XXX_SIM.M95XXX_Macro_mux.tSE);
		READ_CONFIG_SAFE_REG;//15
		
		
        WRITE_ENABLE;//06
        SECTOR_ERASE('h6000);    
        #(M95XXX_SIM.M95XXX_Macro_mux.tSE);
        
        READ_CONFIG_SAFE_REG;//15
//////=======================================================///////      
//////=================== BLOCK ERASE instruction ==========///////	   
        $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING12: BLOCK ERASE (BKER) VERIFICATION.  ==");
        else
          $display("==  TESTING11: BLOCK ERASE (BKER) VERIFICATION.  ==");

        $display("======================================================");
        ///////------In order to verify the BKER instruction-------------------/////
        WRITE_ENABLE;//06
        SECTOR_ERASE('h00000); 
          #(M95XXX_SIM.M95XXX_Macro_mux.tSE);
        ///////-------------------------/////
    W = 1;
	
         WRITE_ENABLE;//06
         WRITE_STATUS_REGISTER(1, 8'b00010000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
         READ_STATUS_REGISTER;//05
        
		 WRITE_ENABLE;//06
		 BLOCK_ERASE('h380100); /////ERROR : TEMPT TO MODIFY A PROTECTED MEMORY AREA
		#(M95XXX_SIM.M95XXX_Macro_mux.tBE);
		 READ_CONFIG_SAFE_REG;//15
		 CLEAR_SAFETY_STI_FLAGS;//50
        
		 WRITE_ENABLE;//06
         WRITE_STATUS_REGISTER(1, 8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
         READ_STATUS_REGISTER;//05
         BLOCK_ERASE('h10000); //////// ERROR : WRITE ENABLE IS NOT DRIVEN 
		#(M95XXX_SIM.M95XXX_Macro_mux.tBE);
		 READ_CONFIG_SAFE_REG;//15
        
        indirizzo = 'h00000;
        WRITE_ENABLE;//06
        BLOCK_ERASE('h10000);
        #(M95XXX_SIM.M95XXX_Macro_mux.tBE);

        $display("==========================================================");
        $display("%t=========\n DRIVER: Enabling BUFFER MODE to WRITE A BLOCK OF THE MEMORY  \n ================",$realtime);
	$display("==========================================================");
        READ_STATUS_REGISTER;//05
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h02); //81
       
        READ_VOLATILE_REG; //85
        READ_CONFIG_SAFE_REG;//15
        
        indirizzo = 'h10000;
	WRITE_ENABLE;//06
			


	for (x=0; x<128 ; x = x+1) //128 pages is a block of memory
		begin
			time_instruc_start = $realtime();
			if (x == 0)
				PAGE_PROGRAM_IN(`PAGE_SIZE, 8'h0F , indirizzo);
			else
			begin
				READ_CONFIG_SAFE_REG;
				PAGE_PROGRAM_IN(`PAGE_SIZE, 8'h0F ,indirizzo+(512*x)); //500+(x%12)
//$display("DEBUG: ADDRESS = %h ",indirizzo+(512*x));
				time_instruc_end = $realtime();
				time_wait = time_instruc_end - time_instruc_start ;
				if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
					#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait); 
				//#(M95XXX_SIM.M95XXX_Macro_mux.tPP); 
			end
		end
 
	READ_CONFIG_SAFE_REG; //15
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);
			
	$display("\n\t==========================================");
	$display("\t======= DISABLING BUFFER MODE=============");
        $display("\t==========================================");
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h01); //81      
        READ_VOLATILE_REG; //85
        READ_CONFIG_SAFE_REG;//15
 		$display("Driver: READING A BLOCK OF THE MEMORY ");
		FQ_READ_DATA_BYTES((128*`PAGE_SIZE),'h10000);
		#((M95XXX_SIM.M95XXX_Macro_mux.tPW));
		 WRITE_ENABLE;//06
         BLOCK_ERASE('h10000);    
        #(M95XXX_SIM.M95XXX_Macro_mux.tBE);
         READ_CONFIG_SAFE_REG;//15
		$display("Driver: READING THE ERASED BLOCK OF THE MEMORY ");
        FQ_READ_DATA_BYTES(128*`PAGE_SIZE,'h10000);
        
      
        
//////=======================================================///////
////// ================ CHIP ERASE Instruction ==============///////	     
         $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING13: CHIP ERASE (CHER) VERIFICATION.  ==");
        else
          $display("==  TESTING12: CHIP ERASE (CHER) VERIFICATION.  ==");

        $display("======================================================");
            
    W=1;
          
         WRITE_ENABLE;//06
         WRITE_STATUS_REGISTER(1, 8'b01011000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
         READ_STATUS_REGISTER;//05
        
		 WRITE_ENABLE;//06
		 CHIP_ERASE; /////ERROR : TEMPT TO MODIFY A PROTECTED MEMORY AREA
		#(M95XXX_SIM.M95XXX_Macro_mux.tCE);
		 READ_CONFIG_SAFE_REG;//15
		 CLEAR_SAFETY_STI_FLAGS;//50
        
		 WRITE_ENABLE;//06
         WRITE_STATUS_REGISTER(1, 8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
         READ_STATUS_REGISTER;//05
         CHIP_ERASE; //////// ERROR : WRITE ENABLE IS NOT DRIVEN 
		#(M95XXX_SIM.M95XXX_Macro_mux.tCE);
		 READ_CONFIG_SAFE_REG;//15
		
		WRITE_ENABLE;//06
		PAGE_PROGRAM_IN(512,'h56,'h8000);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);
		FQ_READ_DATA_BYTES(4096,'h8000);
		///////------In order to verify the CHER instruction-------------------/////
		indirizzo = 'h00000;
        WRITE_ENABLE;//06
        CHIP_ERASE;//C7
        #(M95XXX_SIM.M95XXX_Macro_mux.tCE);
 

        $display("==========================================================");
        $display("%t=========\n DRIVER: Enabling BUFFER MODE to WRITE THE WHOLE MEMORY  \n ================",$realtime);
		$display("==========================================================");
        READ_STATUS_REGISTER;//05
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h02);  //81
       
        READ_VOLATILE_REG;//85
        READ_CONFIG_SAFE_REG;//15
        
        indirizzo = 'h000;
		WRITE_ENABLE;//06

	for (x=0; x<`PAGES ; x = x+1) //8192 pages is the total memory
		begin
			time_instruc_start = $realtime();
			if (x == 0)
				PAGE_PROGRAM_IN(`PAGE_SIZE, 8'h0F , indirizzo);
			else
			begin
				READ_CONFIG_SAFE_REG;
				PAGE_PROGRAM_IN(`PAGE_SIZE, 8'h0F ,indirizzo+(512*x)); //500+(x%12)
//$display("DEBUG: ADDRESS = %h ",indirizzo+(512*x));
				time_instruc_end = $realtime();
				time_wait = time_instruc_end - time_instruc_start ;
				if ( ((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait) > 0.0 )		        	
					#((M95XXX_SIM.M95XXX_Macro_mux.tPP)-time_wait); 
				//#(M95XXX_SIM.M95XXX_Macro_mux.tPP); 
			end
		end
 
	READ_CONFIG_SAFE_REG; //15
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);
				
			
	$display("\n\t==========================================");
	$display("\t======= DISABLING BUFFER MODE=============");
        $display("\t==========================================");
        WRITE_ENABLE;//06
        WRITE_VOLATILE_REG('h01); //81      
        READ_VOLATILE_REG; //85
        READ_CONFIG_SAFE_REG;//15
 		$display("%t Driver: READING A QUARTER OF THE WHOLE WRITTEN MEMORY ",$realtime);
		FQ_READ_DATA_BYTES((`PAGES*`PAGE_SIZE/4),'h0000);
		#((M95XXX_SIM.M95XXX_Macro_mux.tPW));
        WRITE_ENABLE;//06
        CHIP_ERASE; //C7    
        #(M95XXX_SIM.M95XXX_Macro_mux.tCE);
        READ_CONFIG_SAFE_REG;//15
		$display("Driver: READING HALF OF THE WHOLE ERASED MEMORY ");
        FQ_READ_DATA_BYTES((`PAGES*`PAGE_SIZE/2),'h0000);     
        
//////=====================================================/////
////// ================= PAGE ERASE Instruction =========///////	     
         $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING14: PAGE ERASE (PGER) VERIFICATION.  =======");
        else
          $display("==  TESTING13: PAGE ERASE (PGER) VERIFICATION.  =======");

        $display("======================================================");
            
    W=1;
          
          WRITE_ENABLE;//06
          WRITE_STATUS_REGISTER(1, 8'b01010100);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
          READ_STATUS_REGISTER;//05
        
	WRITE_ENABLE;//06
	 PAGE_ERASE('h7a120); /////ERROR : TEMPT TO MODIFY A PROTECTED MEMORY AREA
	#(M95XXX_SIM.M95XXX_Macro_mux.tPE);
	 READ_CONFIG_SAFE_REG;//15
	CLEAR_SAFETY_STI_FLAGS;//50
        
	 WRITE_ENABLE;//06
         WRITE_STATUS_REGISTER(1, 8'b0000_0000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
         READ_STATUS_REGISTER;//05
         PAGE_ERASE('h16000); //////// ERROR : WRITE ENABLE IS NOT DRIVEN
	#(M95XXX_SIM.M95XXX_Macro_mux.tPE);
	 READ_CONFIG_SAFE_REG;//15
        
	WRITE_ENABLE;//06
	PAGE_PROGRAM_IN(512,'h57,'h16000);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPP);
	FQ_READ_DATA_BYTES(512,'h16000);//4096
		
        WRITE_ENABLE;//06
        PAGE_ERASE('h16000);    
        #(M95XXX_SIM.M95XXX_Macro_mux.tPE);
        FQ_READ_DATA_BYTES(512,'h16000);
         READ_CONFIG_SAFE_REG;//15
       
//////=====================================================/////
//////----------- Read SFDP register (RDSFDP) INSTRUCTION
//////----------------------------//////////// 

        $display("======================================================");
        if (`IDPAGE)
          $display("==  TESTING15: Read SFDP (RDSFDP) VERIFICATION.  =====");
        else
          $display("==  TESTING14: Read SFDP (RDSFDP) VERIFICATION.  =====");

        $display("======================================================");
      
        W=1;
          
         READ_SFDP(20,`MEM_ADDR_BITS'h1000); //should be error because I would read over the 512 bytes 
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
         READ_SFDP(10,`MEM_ADDR_BITS'h00);  
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
         READ_SFDP(30,`MEM_ADDR_BITS'h1EA);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
         READ_SFDP(`PAGE_SIZE,`MEM_ADDR_BITS'h00);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);       
  
    
$display("======================================================");
$display("PAGE PROGRAM TEMPT TO WRITE IN A PROTECTED MEMORY AREA");
$display("======================================================");

		WRITE_ENABLE;//06
          WRITE_STATUS_REGISTER(1,8'b01011000);//01
        #(M95XXX_SIM.M95XXX_Macro_mux.tWSCR);
          READ_STATUS_REGISTER;//05
		  
		WRITE_ENABLE;//06
		PAGE_PROGRAM_IN(5, 'h11, 'hd4796); //Would be ERROR, tempt to program a protected memory area, then set the PAMAF & PRF bits
		#(M95XXX_SIM.M95XXX_Macro_mux.tPP);
		READ_CONFIG_SAFE_REG;//15
		CLEAR_SAFETY_STI_FLAGS;//50
		READ_CONFIG_SAFE_REG;//15
        
//////=====================================================/////
//////----------- Reset Enable (RSTEN) and Software Reset (RESET) INSTRUCTIONS
///////----------------------------//////////// 

        $display("==================================================================================");
        if (`IDPAGE)
          $display("==  TESTING16: Reset Enable (RSTEN) and Software Reset (RESET) VERIFICATION.  ====");
        else
          $display("==  TESTING15: Reset Enable (RSTEN) and Software Reset (RESET) VERIFICATION.  ====");

        $display("==================================================================================");
      
        W=1;
          
         RESET_ENABLE;
         FAST_READ_ID(3,`MEM_ADDR_BITS'h00);//;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
         RESET_SOFTWARE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
         RESET_ENABLE;
         RESET_SOFTWARE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        WRITE_ENABLE;//06
        CHIP_ERASE;//C7
       #(M95XXX_SIM.M95XXX_Macro_mux.tPW);/////tCE;
        RESET_ENABLE;
        RESET_SOFTWARE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tRST3);
       #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
       
        WRITE_ENABLE;//06
        BLOCK_ERASE('h10000);
       #(M95XXX_SIM.M95XXX_Macro_mux.tPW);//////tBE;
        RESET_ENABLE;
        RESET_SOFTWARE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tRST2);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
//////=====================================================/////
//////----------- Deep Power-down enter (RSTEN) and Deep power-down release (RESET) INSTRUCTIONS
///////----------------------------//////////// 

        $display("==================================================================================");
        if (`IDPAGE)
          $display("==  TESTING17: Deep Power-down enter (DPD) and Deep power-down release (RDPD) VERIFICATION.  ====");
        else
          $display("==  TESTING16: Deep Power-down enter (DPD) and Deep power-down release (RDPD) VERIFICATION.  ====");

        $display("==================================================================================");
      
        W=1;
        DEEP_POWER_ENTER;
        //#(M95XXX_SIM.M95XXX_Macro_mux.tDP);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
        FQ_READ_DATA_BYTES(10,'h16000);//instruction rejected
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
      // WRITE_ENABLE;//instruction rejected
	 	PAGE_ERASE('h7a120);//instruction rejected
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
        RESET_ENABLE;
        RESET_SOFTWARE;
        #(M95XXX_SIM.M95XXX_Macro_mux.tRST1);
        
        FQ_READ_DATA_BYTES(10,'h16000);
        #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        
        DEEP_POWER_ENTER;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDP);
        //#(M95XXX_SIM.M95XXX_Macro_mux.tPW);
        RELEASE_DEEP_POWER;
        #(M95XXX_SIM.M95XXX_Macro_mux.tRDPD);//Release Deep power-down delay to !S low
        #(M95XXX_SIM.M95XXX_Macro_mux.tRDPSL);//Delay for S low (new instruction) after !S high from Deep power-down instruction
       // #(M95XXX_SIM.M95XXX_Macro_mux.tPW);
/////=========================///////////////

	   $display("========================================================");
        if (`IDPAGE)
          $display("==  TESTING18: THE VIOLATED AC TIMING VERIFICATION.  ===");
        else
          $display("==  TESTING17: THE VIOLATED AC TIMING VERIFICATION.  ===");

        $display("========================================================");
        //Following code executes unmeaning operation. It is only used for checking the AC Timing out of spec.
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL - 1);      //violated the /S not active hold time //violated the clock high time
        S = 1'b0;
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCL - 1);        //violated the /S active setup time //violated the clock low time
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCL);
        D = ~D;             //change the value on "D" input pin
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH - 1);      //violated the Data In Setup Time

        #(M95XXX_SIM.M95XXX_Macro_mux.tCHDX - 1);      //violated the Data In Hold Time
        D = ~D;             //change the value on "D" input pin
        #(M95XXX_SIM.M95XXX_Macro_mux.tCH);
        C = 1'b0;

        #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH - 1);      //violated the /S Active Hold Time //violated the clock high time
        S = 1'b1;
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCL - 1);        //violated the /S Active Setup Time //violated the clock low time //violated /S Deselest Time

        #1;                 //violated the /S not active hold time
        S = 1'b0;
        
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCL);

        #(M95XXX_SIM.M95XXX_Macro_mux.tCH);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCLHL);          //Clock Low Set-Up Time before /HOLD Active = 0s
        HOLD = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tHLCH - 1);      //violated the CLock Low Hold Time after /HOLD Active //violated the clock low time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCH);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tCLHH);          //Clock Low Set-Up Time before /HOLD Not Active = 0s
        HOLD = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tHHCH - 1);      //violated the CLock Low Hold Time after /HOLD Not Active //violated the clock low time

        #100;
        S = 1'b1;
        #200;

      
        if (!`VALID_PRT) 
        begin
           $display("\n######################################################################");
           $display("      ERROR: Part Choosen is NOT a valid Part ");
           $display("######################################################################\n");
        end     

           $display("\n######################################################################");
           $display("      TESTS DONE ");
           $display("######################################################################\n");



        $stop;            //testing completed
end
//===============================================
//Stimuli task definition
//===============================================


//pragma protect 
//pragma protect begin

`define logicbit 1'b0

task WRITE_ENABLEi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==5)||(i==6))  D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Write Enable Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task WRITE_ENABLE;
   WRITE_ENABLEi(`logicbit);
endtask

task WRITE_ENABLEh;
   WRITE_ENABLEi(1'b1);
endtask
//pragma protect 
//pragma protect begin
//===============================================
task WRITE_DISABLEi;
input initclk;
begin
    $display("%t DRIVER: WRITE DISABLE INSTRUCTION SENDING",$realtime);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if(i==5) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Write Disable Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task WRITE_DISABLE;
   WRITE_DISABLEi(`logicbit);
endtask

task WRITE_DISABLEh;
   WRITE_DISABLEi(1'b1);
endtask

//===============================================
//pragma protect 
//pragma protect begin
task READ_STATUS_REGISTERi;
input initclk;
begin
    //----------------------instruction
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==5)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read status register
    for(i=0;i<=7;i=i+1)
    begin
        C = 1'b1;
//        sr = {sr[6:0],Q};
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        sr = {sr[6:0],Q};
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
    end
    $display("%t: STATUS_REGISTER = [%b]",$realtime,sr);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Read Status Register Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task READ_STATUS_REGISTER;
   READ_STATUS_REGISTERi(`logicbit);
endtask

task READ_STATUS_REGISTERh;
   READ_STATUS_REGISTERi(1'b1);
endtask

//===============================================
task POLLING_WITH_SEL_LOOP_ON_RDSR_DESEL;
begin
		//pragma protect 
//pragma protect begin
    //----------------------instruction
    $display("%t DRIVER : POLLING_WITH_SEL_LOOP_ON_RDSR_DESEL  started! ",$realtime);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==5)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read status register
	sr = 03;
    while (sr != 0)
	begin
		for(i=0;i<=7;i=i+1)
		begin
			C = 1'b1;
			sr = {sr[6:0],Q};
			#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
			C = 1'b0;
			#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
				//$display(" SR = %b ;  Q = %b ;", sr, Q);
		end
		$display("%t: STATUS_REGISTER = [%b]",$realtime,sr);
	end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
$display("task POLLING_WITH_SEL_LOOP_ON_RDSR_DESEL finished \n =============================================");
end
endtask
//pragma protect end
//===============================================
task POLLING_WITH_LOOP_ON_SEL_RDSR_DESEL;
begin
		//pragma protect 
//pragma protect begin
    //----------------------instruction
  if (C==1) C=1'b0;

	sr = 03;
    while (sr != 0)
	begin	
		S = 1'b1;
		#(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
		S = 1'b0;
		#(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
		for(i=0;i<=7;i=i+1)
		begin
			if((i==5)||(i==7)) D = 1'b1;
			else D = 1'b0;
			#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
			C = 1'b1;
			#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
			C = 1'b0;
			#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		end
		#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		//----------------------read status register
		for(i=0;i<=7;i=i+1)
		begin
			C = 1'b1;
			#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
			sr = {sr[6:0],Q};
			C = 1'b0;
			#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		end
		$display("%t: STATUS_REGISTER = [%b]",$realtime,sr);
		#(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
		S = 1'b1;
		#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
	end
$display("task POLLING_WITH_LOOP_ON_SEL_RDSR_DESEL finished \n ==============================================");
end
endtask

////============WRITE STATUS AND CONFIGURATION REGISTERS ==========================
task WRITE_STATUS_REGISTERi ;
input n;
input[7:0] sr_data;
input[7:0] conf_data;
input initclk;
integer n;
	
begin 
	
	    //----------------------instruction
    //$display("DRIVER:writing the status register with data %b", sr_data);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if(i==7)    D = 1'b1;
        else        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------write status register
    	if(n==1)
	    	begin
	    	$display("%t DRIVER: Writing the status register with data %b",$realtime, sr_data);
	    	begin
    			for(i=0;i<=7;i=i+1)
    				begin
        	D = sr_data[7-i];
	        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
	        C = 1'b1;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
	        if (i==7) C = initclk; else C = 1'b0;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    				end
    			$display("%t : DRIVER: sr_data =%b", $realtime,sr_data);
	    	end
	    	end
    	else if(n==2)
	    	begin
	    	
		    begin
			    status_conf_reg={sr_data,conf_data};
			    $display("%t DRIVER: Writing the status register with data %b",$realtime,status_conf_reg);
			    for(i=0;i<=15;i=i+1)
    				begin
        	D = status_conf_reg[15-i];
	        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
	        C = 1'b1;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
	        if (i==7) C = initclk; else C = 1'b0;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    				end
    		$display("%t : DRIVER: status_conf_reg =%b",$realtime, status_conf_reg);
		    end
		    end
		    
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Write Status Register Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task WRITE_STATUS_REGISTER;
input n;
input [15:0] data;
reg[7:0] sr_data;
reg[7:0] conf_data;
integer n;
			//pragma protect 
//pragma protect begin
begin
		if (n == 1 || n == 2)
		begin
			if(n == 1)
				begin
				sr_data = data[7:0];
				conf_data = data[15:8];
				end
			else
				begin
				sr_data = data[15:8];
				conf_data = data[7:0];
				end
		    WRITE_STATUS_REGISTERi(n,sr_data,conf_data,`logicbit);
		end
	else
		$display("%t : DRIVER : WARNING : Bytes number inserted (n = %d) has exceeded the maximun value that is 2. The instruction is rejected!",$realtime, n);
end
endtask

task WRITE_STATUS_REGISTERh;
input n;
input [15:0] data;
reg[7:0] sr_data;
reg[7:0] conf_data;
integer n;
begin
if (n == 1 || n == 2)
		begin
			if(n == 1)
				begin
				sr_data = data[7:0];
				conf_data = data[15:8];
				end
			else
				begin
				sr_data = data[15:8];
				conf_data = data[7:0];
				end
		    WRITE_STATUS_REGISTERi(n,sr_data,conf_data,`logicbit);
		end
	else
		$display("%t : DRIVER : WARNING : Bytes number inserted (n = %d) has exceeded the maximun value that is 2. The instruction is rejected!",$realtime, n);
end
endtask

//===============================================
task READ_DATA_BYTESi;
input n;
input[23:0] address;
input initclk;
integer j,n;
begin
	$display("DRIVER: STARTING send READ DATA instruction from address [%h]=[%b] for %d bytes",address,address,n);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==6)||(i==7)) D = 1'b1;
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];      // 9 bit addressing    
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH); //_slow
    end
    //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);//_slow);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);//_slow
        //$display("%tDRIVER: ADDRESS [%h]=[%b]",$realtime,address,address);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n;i=i+1)
    begin
//        address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            if (C==1) C = 1'b0; else C = 1'b1;
//            read_dat = {read_dat[6:0],Q};
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);//_slow);
            read_dat = {read_dat[6:0],Q};
            address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
           
            if (i==n&&j==7) C = initclk; else C = 1'b0;

            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow);//_slow);
        end
    $display("%t DRIVER: READ RESULT of byte number %d of %d :\n\t\t\t ADDRESS = [%h], DATA = [%h]\n",$realtime,i,n,address,read_dat);    
    end
    
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
$display("%t DRIVER:  Read Data Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task READ_DATA_BYTES;
input n;
input[23:0] address;
integer n;
begin
   READ_DATA_BYTESi(n,address,`logicbit);
end
endtask

task READ_DATA_BYTESh;
input n;
input[23:0] address;
integer n;
begin
   READ_DATA_BYTESi(n,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task FAST_READ_DATA_BYTESi;
input n;
input[23:0] address;
input initclk;
integer j,n;
reg [0:7] data;
begin
	$display("===========================================================");
	$display("DRIVER: STARTING send FAST SINGLE READ DATA instruction from address [%h]=[%b] for %d bytes",address,address,n);
    if (C==1) C=1'b0;
    
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0; HOLD = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
   for(i=0;i<=7;i=i+1)
    begin
        if((i==4)||(i==6)||(i==7))
	        begin
		        D = 1'b1;
		    end
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];      // 9 bit addressing    
        else D = 1'b0;
        data[i] = D;
        
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
   //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //$display("address %h ", address);
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n+1;i=i+1) //n+1 because there is a dummy byte before to send the datas! 
    begin	    
//        address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            if (i<=1)//&& j <= 1)
	            begin
		           if (C==1) C = 1'b0; else C = 1'b1; 
//     		       read_dat = {read_dat[6:0],Q};
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            if (i == 1 && j == 7)
			            $display("%t DRIVER: Dummy Byte Ended",$realtime);
		            else
		            $display("%t DRIVER: Dummy byte time waiting",$realtime);
		            
		            if (i==n&&j==7) C = initclk; else C = 1'b0;
		           	
		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		            //$display("address2 %h ", address);
	            end
            else if (i > 1)
	         begin
	             if (C==1) C = 1'b0; else C = 1'b1;
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            read_dat = {read_dat[6:0],Q};
		            address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
		            if (i==n&&j==7) C = initclk; else C = 1'b0;
	             	//$display("%t DRIVER: n = %d i = %d j = %d \n",$realtime,n, i, j);
		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		            //$display("address3 %h ", address);
		            //$display("%t DRIVER Q = %b read_dat = %h i = %d   j = %d  ", $realtime,Q,read_dat, i,j);
		     end
        end
        if(i > 1)
           $display("\n%t DRIVER: FAST Single READ RESULT of byte number %d of %d :\n\t\t\t ADDRESS = [%h], DATA = [%h]\n",$realtime,i-1,n,address,read_dat);
    //$display("\n\n DRIVER333 i = %d",$realtime, i);
        
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
 
    
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Fast Read Data Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task FAST_READ_DATA_BYTES;
input n;
input[23:0] address;
integer n;
begin
   FAST_READ_DATA_BYTESi(n,address,`logicbit);
end
endtask

task FAST_READ_DATA_BYTESh;
input n;
input[23:0] address;
integer n;
begin
   FAST_READ_DATA_BYTESi(n,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task FD_READ_DATA_BYTESi;
input n;
input[23:0] address;
input initclk;
integer j,n;
reg [0:7] data;
begin
	$display("===========================================================");
	$display("DRIVER: STARTING send FAST DUAL READ DATA instruction from address [%h]=[%b] for %d bytes",address,address,n);
    if (C==1) C=1'b0;
    
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0; HOLD = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
   for(i=0;i<=7;i=i+1)
    begin
        if((i==2)||(i==3)||(i==4)||(i==6)||(i==7))
	        begin
		        D = 1'b1;
		    end
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];      // 9 bit addressing    
        else D = 1'b0;
        data[i] = D;
        
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
   //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    FDREAD = 1; 
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n+4;i=i+1) //n+1 because there is a dummy byte before to send the datas! 
    begin	    
//        address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
        for(j=0;j<=3;j=j+1)
        begin
            if (i<=4 && j <= 1)
	            begin
		           if (C==1) C = 1'b0; else C = 1'b1; 
//     		       read_dat = {read_dat[6:0],Q};
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            if (i == 4 && j == 1)
			            $display("%t DRIVER: Dummy Byte Ended",$realtime);
		            else
		            $display("%t DRIVER: Dummy byte time waiting",$realtime);
		            
		            if (i==n&&j==7) C = initclk; else C = 1'b0;
		           

		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
	            end
            else if (i > 4)
	         begin
	             if (C==1) C = 1'b0; else C = 1'b1;
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            read_dat = {read_dat[5:0],Q,D_bidir};
		            address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
		            if (i==n&&j==7) C = initclk; else C = 1'b0;
	             	//$display("%t DRIVER: n = %d i = %d j = %d \n",$realtime,n, i, j);
		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		     end
        end
        if(i > 4)
           $display("\n%t DRIVER: FAST DUAL READ RESULT of byte number %d of %d :\n\t\t\t ADDRESS = [%h], DATA = [%h]\n",$realtime,i-4,n,address,read_dat);
    //$display("\n\n DRIVER333 i = %d",$realtime, i);
        
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    FDREAD = 0;
    
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Fast Dual Read Data Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task FD_READ_DATA_BYTES;
input n;
input[23:0] address;
integer n;
begin
   FD_READ_DATA_BYTESi(n,address,`logicbit);
end
endtask

task FD_READ_DATA_BYTESh;
input n;
input[23:0] address;
integer n;
begin
   FD_READ_DATA_BYTESi(n,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task FQ_READ_DATA_BYTESi;
input n;
input[23:0] address;
input initclk;
integer j,n;
reg [0:7] data;
begin
	$display("DRIVER: STARTING send FAST QUAD READ DATA instruction from address [%h]=[%b] for %d bytes",address,address,n);
    if (C==1) C=1'b0;
    FQREAD = 1;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0; HOLD = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
   for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==2)||(i==4)||(i==6)||(i==7))
	        begin
		        D = 1'b1;
		    end
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];      // 9 bit addressing    
        else D = 1'b0;
        data[i] = D;
        
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) C = 1'b1; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
   //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
	    
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1) C = 1'b0; else C = 1'b1;
     //   $display("%t DRIVERCLOCK = %b   i = %d", $realtime, C, i);
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0) 
	        C = 1'b1; 
        else 
	        begin 
		        C = 1'b0;
		    	if( i == add_bytes*8-1)
			    	FQREAD_D = 1; 
		    end
      //  $display("%t DRIVERCLOCK2 = %b   i = %d", $realtime, C, i);
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
  
   end
    
    //FQREAD_D = 1; 
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
    
    //----------------------read data bytes
    for(i=1;i<=n+4;i=i+1) //n+1 because there is a dummy byte before to send the datas! 
    begin	    
	    
//        address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
        for(j=0;j<=1;j=j+1)
        begin
            if (i<=4)
	            begin
		           if (C==1) C = 1'b0; else C = 1'b1; 
//     		       read_dat = {read_dat[6:0],Q};
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            
		           if (i == 4 && j == 1 )
			            $display("%t DRIVER: Dummy Byte Ended",$realtime);
		           else
			           
		            $display("%t DRIVER: Dummy byte time waiting",$realtime);
		           
		           
		            if (i==n&&j==7) C = initclk; else C = 1'b0;

		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
	            end
            else
	         begin
	             if (C==1) C = 1'b0; else C = 1'b1;
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            read_dat = {read_dat[3:0],HOLD_bidir,W_bidir,Q,D_bidir};
		            address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
		            if (i==n&&j==7) C = initclk; else C = 1'b0;
 					//$display("%t DRIVER: n = %d i = %d j = %d \n",$realtime,n, i, j);
		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		     end
        end
        if(i > 4)
        $display("\n%t DRIVER: FAST QUAD READ RESULT of byte number %d of %d :\n\t\t\t ADDRESS = [%h], DATA = [%h]\n",$realtime,i-4,n,address,read_dat);
    
    //$display("\n\n DRIVER333 i = %d",$realtime, i);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    FQREAD_D = 0;
    FQREAD = 0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Fast Quad Read Data Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task FQ_READ_DATA_BYTES;
input n;
input[23:0] address;
integer n;
begin
   FQ_READ_DATA_BYTESi(n,address,`logicbit);
end
endtask

task FQ_READ_DATA_BYTESh;
input n;
input[23:0] address;
integer n;
begin
   FQ_READ_DATA_BYTESi(n,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task WRITE_DATA_INi;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
input initclk;
integer j,n;
begin
	$display("%t DRIVER: Page Write instruction IS STARTING. \n\t \t writing %d bytes [%b]=[%h] in address [%h]=[%b]",$realtime,n,data,data,address,address);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if(i==6) D = 1'b1;
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];          
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1)
           C = 1'b0;
        else
           C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0)
           C = 1'b1;
        else
           C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        if (C==1)
           C = 1'b0;
        else
           C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (C==0)
           C = 1'b1;
        else
           C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);

    end
    //----------------------write data
    for(i=0;i<=n-1;i=i+1)
    begin
        for(j=0;j<=7;j=j+1)
        begin
            D = data[7-j];
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);      //data setup time
            if (C==1) C = 1'b0; else C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            if (i==n-1&&j==7) C = initclk; else C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
        end
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    //$display("%t DRIVER: Page Write Instruction Ended \n =========================================================",$realtime);
    
end
endtask
//pragma protect end
task WRITE_DATA_IN;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   WRITE_DATA_INi(n,data,address,`logicbit);
end
endtask

task WRITE_DATA_INh;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   WRITE_DATA_INi(n,data,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task WRITE_ID_PAGEi;
input n;                    //the number of data byte that be written in
//input idn_lock;
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
input initclk;
integer j,n;
begin
	$display("%t DRIVER: Writing %d addresses in ID PAGE from address %h", $realtime,n, address);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==0||i==6)) D = 1'b1;
//        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];          
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------address

    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------write data

    for(i=0;i<=n-1;i=i+1)
    begin
	    $display("%t DRIVER: Writing the Data %h in the ADDRESS = [%h]\n",$realtime,data,address+i);
        for(j=0;j<=7;j=j+1)
        begin
            D = data[7-j];
            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);      //data setup time
            C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            if (i==n-1&&j==7) C = initclk; else C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        end
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Write ID PAGE Instruction Ended \n =========================================================",$realtime);
    
end

endtask
//pragma protect end
task WRITE_ID_PAGE;
input n;                    //the number of data byte that be written in
//input idn_lock;
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   WRITE_ID_PAGEi(n,data,address,`logicbit);
end
endtask

task WRITE_ID_PAGEh;
input n;                    //the number of data byte that be written in
//input idn_lock;
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   WRITE_ID_PAGEi(n,data,address,1'b1);
end
endtask
//pragma protect 
//pragma protect begin
//===============================================
task READ_ID_PAGEi;
input n;
//input idn_status;
input[23:0] address;
input initclk;
integer j,n;
begin
	$display("%t DRIVER: Reading %d addresses in ID PAGE from address %h", $realtime,n, address);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==0)||(i==6)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);//
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n;i=i+1)
    begin
        address = U_M95XXX.memory_address;//[`MEM_ADDR_BITS-`PAGE_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            C = 1'b1;
//            read_dat = {read_dat[6:0],Q};  No because it has to read in the falling edge of the clock
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
//$display("%t DRIVER DEBUG: Clock from 0 to 1 | Q = %b | tH_CLK_slow = %g ", $realtime, Q, (M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow) );  
            read_dat = {read_dat[6:0],Q};
            if (i==n&&j==7) 
		C =initclk; 
	    else begin
		C = 1'b0;
	    end
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow);
//$display("%t DRIVER DEBUG: Clock from 1 to 0  | tL_CLK_slow = %g ", $realtime,(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow));  
      end
        $display("%t DRIVER: READ RESULT: ADDRESS = [%h], DATA = [%h]\n",$realtime,address,read_dat);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Read Instruction Ended \n =========================================================",$realtime);
end
endtask
//pragma protect end
task READ_ID_PAGE;
input n;
//input idn_status;
input[23:0] address;
integer n;
begin
   READ_ID_PAGEi(n,address,`logicbit);
end
endtask

task READ_ID_PAGEh;
input n;
//input idn_status;
input[23:0] address;
integer n;
begin
   READ_ID_PAGEi(n,address,1'b1);
end
endtask

//===============================================
task READ_DATA_BYTES_HD;
input n;
input id;
input[23:0] address;
	//pragma protect 
//pragma protect begin
integer j,n,k;
reg id;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((id==1)&&(i==0)) D = 1'b1;
        else if((i==6)||(i==7)) D = 1'b1;
        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];          
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------address
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n;i=i+1)
    begin
        address = U_M95XXX.memory_address[`MEM_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            C = 1'b1;
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
            read_dat = {read_dat[6:0],Q};
            C = 1'b0;
            //#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-40);
            #(M95XXX_SIM.M95XXX_Macro_mux.tCLHL);      //clk low setup time before "HOLD" active
            //---------------------------------------------
            HOLD = 1'b0;    //HOLD Condition start
            for(k=0;k<1;k=k+1)
            begin
                //#60;
                #(M95XXX_SIM.M95XXX_Macro_mux.tHLCH);  //clk low hold time after "HOLD" active
                #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tCLHL-M95XXX_SIM.M95XXX_Macro_mux.tHLCH);
                C = 1'b1;
                #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK_slow);
                C = 1'b0;
                //#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-40);
                #(M95XXX_SIM.M95XXX_Macro_mux.tCLHL);  //clk low setup time before "HOLD" active
            end
            HOLD = 1'b1;    //HOLD Condition end
            //#60;
            #(M95XXX_SIM.M95XXX_Macro_mux.tHLCH);      //clk low hold time after "HOLD" active
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK_slow-M95XXX_SIM.M95XXX_Macro_mux.tCLHL-M95XXX_SIM.M95XXX_Macro_mux.tHLCH);
            //---------------------------------------------        
        end
        $display("%t: READ RESULT: ADDRESS = [%h], DATA = [%h]\n",$realtime,address,read_dat);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end
//===============================================
task JEDID;
		begin
			JEDIDi(`logicbit);
		end
endtask
//pragma protect 
//pragma protect begin
task JEDIDi;
input initclk;
 begin
    //----------------------instruction
    $display("%t DRIVER: JEDEC INSTRUCTION STARTED",$realtime);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) //32
    	begin
	   		if(i==1 || i==2)    D = 1'b0;
       		else        D = 1'b1;
	   		#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
       	C = 1'b1;
       	#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
       	C = 1'b0;
	   	#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
   		end
   		#(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
////        	//------------------Read REGISTER with Identification Memory Data
     for(i=0;i<=23;i=i+1)
  		begin
       	C = 1'b1;
       	jedec_data = {jedec_data[22:0],Q};
       	#(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
	  		if (i==23) C = initclk; else C = 1'b0;
	   	#(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
		end
   	#(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time   
	S = 1'b1;
   	#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
$display("%t DRIVER: Jedec Instruction Ended \n =========================================================",$realtime);
  end	
    


endtask

///-------TASK SECTOR ERASE

task SECTOR_ERASEi;
input[23:0] address_sect;
input initclk;


begin

	//----------------------instruction
    $display("%t DRIVER: SECTOR ERASE INSTRUCTION STARTED",$realtime);
	   $display("%t: DRIVER : ADDRESS %b [%h h]",$realtime,address_sect,address_sect);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) 
    begin
	    if(i==2)    D = 1'b1;
        else        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
 
   //----------address
   for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
	    //$display("%t D = %b  ||| address_sect = %b ||| i = %d ",$realtime, D, address_sect, i );
        D = address_sect[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Sector Erase Instruction Ended \n =========================================================",$realtime);
end

endtask
//pragma protect end
task SECTOR_ERASE;
input[23:0]address_sect;
	
		begin
			SECTOR_ERASEi(address_sect,`logicbit);
		end
endtask


task SECTOR_ERASEh;
input[23:0]address_sect;
		begin
			$display(" task sector_eraseh | ADDRESS = %b  %h ", address_sect,address_sect);
			SECTOR_ERASEi(address_sect,1'b1);
			
		end
endtask


///------------------------------------
task JEDID_LOOP;
input n;
integer n;
	begin
		JEDID_LOOPi(n,`logicbit);//JEDID_LOOPi(n,`logicbit);
	end
endtask
//pragma protect 
//pragma protect begin
task JEDID_LOOPi;
input n; 
input initclk;
integer n;
begin
    //----------------------instruction
    $display("%t DRIVER: JEDEC INSTRUCTION %d CYCLE LOOPs STARTED",$realtime,n);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) //32
    begin
        if(i==1 || i==2)    D = 1'b0;
        else        D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
////        	//------------------Read REGISTER
  	      for(i=0;i<=(n*24)-1;i=i+1) 
    begin
        C = 1'b1;
        jedec_data = {jedec_data[22:0],Q};
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (i==23) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
	end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time        
		S = 1'b1;
    	#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    	$display("%t DRIVER: Jedec Loop Instruction Ended \n =========================================================",$realtime);
    end	
    


endtask

//===============================================
task READ_CONFIG_SAFE_REGi;
input initclk;
begin
    //----------------------instruction
    $display("\n\n %t DRIVER: READ Configuration & Safery Registers INSTRUCTION STARTED",$realtime);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) //32
    begin
        if((i==3)||(i==5)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
////        	//------------------Read REGISTER with Identification Memory Data
  	      for(i=0;i<=15;i=i+1)
    begin
        C = 1'b1;
        config_safe_data = {config_safe_data[14:0],Q};
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (i==15) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
	end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time   
		S = 1'b1;
    	#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    	$display("%t DRIVER: Read Configuration & Safety Registers Instruction Ended \n =========================================================",$realtime);
    end	
    
endtask
//pragma protect end
task READ_CONFIG_SAFE_REG;
		begin
			READ_CONFIG_SAFE_REGi(`logicbit);
		end
endtask
///------------------------------------
task READ_CONFIG_SAFE_REG_LOOP;
input n;
integer n;
	begin
		 READ_CONFIG_SAFE_REG_LOOPi(n,`logicbit);
	end
endtask
//pragma protect 
//pragma protect begin
task READ_CONFIG_SAFE_REG_LOOPi;
input n; 
input initclk;
integer n;
begin
    //----------------------instruction
    $display("%t DRIVER: Read Configuration & Safety Registers instruction %d CYCLE LOOPs STARTED",$realtime,n);
    if (C==1) C=1'b0;
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) //32
	    begin
	       if((i==3)||(i==5)||(i==7)) D = 1'b1;
	        else        D = 1'b0;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
	        C = 1'b1;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
	        C = 1'b0;
	        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
	    end
	 #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
       	//------------------Read REGISTER
  	for(i=0; i<5; i=i+1)
	  	begin
		  	for(j=0;j<=15;j=j+1) 
			    begin
				   // $display("%t DRIVER READ_CONFIG_SAFE_REG_LOOP   n = %d  i = %d j = %d ",$realtime, n, i,j);
			        C = 1'b1;
//			        config_safe_data = {config_safe_data[14:0],Q};
			        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
			        config_safe_data = {config_safe_data[14:0],Q};
			        if (i==15) C = initclk; else C = 1'b0;
			        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
			        
			    end
			    $display("%t DRIVER: Configuration & Safety Registers = %b = %h || loop time = i = %d ",$realtime,config_safe_data,config_safe_data,i);
	    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time        
		S = 1'b1;
    	#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    	 $display("%t DRIVER: Read Configuration & Safety Registers Loop Instruction Ended \n =========================================================",$realtime);
    
    end	
   
endtask

//===================TASK CLEAR SAFETY REGISTER (CLRSF)
task CLEAR_SAFETY_STI_FLAGSi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==3))  D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Clear Configuration & Safety Registers Instruction Ended \n =========================================================",$realtime);
    
end

endtask
//pragma protect end
task CLEAR_SAFETY_STI_FLAGS;
   CLEAR_SAFETY_STI_FLAGSi(`logicbit);
endtask

//pragma protect 
//pragma protect begin
//===============================================
task PAGE_PROGRAM_INi;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
input initclk;
integer j,n;
begin
	if(n == 0)
		$display("%t DRIVER: ERROR  'n' must be greater than 0 ",$realtime);
	else
		begin
			$display("\n%t DRIVER: PAGE_PROGRAM_IN instruction IS STARTING. \n\t \t writing %d bytes [%b]=[%h] in address [%h]=[%b]",$realtime,n,data,data,address,address);
		    if (C==1) C=1'b0;
		    S = 1'b1;
		    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
		    S = 1'b0;
		   // $display("%t S = %b",$realtime,S);
		    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
		    $display("\n%t DRIVER: Sending instruction",$realtime);
		    for(i=0;i<=7;i=i+1)
		    begin
		        if(i==6 || i==4) D = 1'b1;
		        else if ((instructionA8==1)&&(i==4)) D = address[`MEM_ADDR_BITS-1];          
		        else D = 1'b0;
		        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
		        if (C==1)
		           C = 1'b0;
		        else
		           C = 1'b1;
		        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		        if (C==0)
		           C = 1'b1;
		        else
		           C = 1'b0;
		        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		    end
		    //----------------------address
		    $display("\n%t DRIVER: Sending Data Address",$realtime);
		    
		    for(i=0;i<=add_bytes*8-1;i=i+1)
		    begin
		        D = address[add_bytes*8-1-i];
		        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
		        if (C==1)
		           C = 1'b0;
		        else
		           C = 1'b1;
		        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		        if (C==0)
		           C = 1'b1;
		        else
		           C = 1'b0;
		        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		
		    end
		    //----------------------write data
		    $display("\n%t DRIVER Sending Data",$realtime);
		    
		    for(i=0;i<=n-1;i=i+1)
		    begin
		        for(j=0;j<=7;j=j+1)
		        begin
		            D = data[7-j];
		            #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);      //data setup time
		            if (C==1) C = 1'b0; else C = 1'b1;
		            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
		            if (i==n-1&&j==7) C = initclk; else C = 1'b0;
		            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		    
		        end
		    end
		    //----------------------
		    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
		    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
		    S = 1'b1;
		    //$display("%t S = %b",$realtime,S);
		    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
		    $display("\n%t DRIVER: Page Program Instruction Ended \n =========================================================\n",$realtime);
	end//dell'else
end

endtask
//pragma protect end
task PAGE_PROGRAM_IN;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   PAGE_PROGRAM_INi(n,data,address,`logicbit);
end
endtask

task PAGE_PROGRAM_INh;
input n;                    //the number of data byte that be written in
input[7:0] data;            //the data written in memory
input[23:0] address;        //the accessed location's address
integer n;
begin
   PAGE_PROGRAM_INi(n,data,address,1'b1);
end
endtask
/////========== TASK READ AND WRITE VOLATILE REGISTER ========//////

//pragma protect 
//pragma protect begin
task WRITE_VOLATILE_REGi;
input[7:0] vr_data;
input initclk;
begin
    //----------------------instruction
  $display("%t DRIVER: Writing %b in the Volatile Register", $realtime, vr_data);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if(i==0 || i==7)    D = 1'b1;
        else        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------write volatile register
    for(i=0;i<=7;i=i+1)
    begin
        D = vr_data[7-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    //$display("%t S = %b ",$realtime,S);
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Write Volatile Register Instruction Ended \n =========================================================",$realtime);
    
end

endtask
//pragma protect end
task WRITE_VOLATILE_REG;
input[7:0] vr_data;
begin
   WRITE_VOLATILE_REGi(vr_data,`logicbit);
end
endtask
	//-------------------------------------------
	
//====================== READ VOLATILE REGISTER =============//
//pragma protect 
//pragma protect begin
task READ_VOLATILE_REGi;
input initclk;
begin
    //----------------------instruction
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==0)||(i==5)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read volatile register  
    for(i=0;i<=7;i=i+1)
    begin
        C = 1'b1;
//        vr = {vr[6:0],Q};
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        vr = {vr[6:0],Q};
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
    end
    $display("%t: VOLATILE_REGISTER = [%b]",$realtime,vr);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Read Volatile Register Instruction Ended \n =========================================================",$realtime);
    
end

endtask
//pragma protect end
task READ_VOLATILE_REG;
   READ_VOLATILE_REGi(`logicbit);
endtask
//==============================================================//
///------TASK READ VOLATILE LOOP

task READ_VOLATILE_REG_LOOP;
input n; 
integer n;		//n is the repetision number of the volatile register
	begin
		READ_VOLATILE_REG_LOOPi(n,`logicbit);
		
	end
endtask
//pragma protect 
//pragma protect begin
task READ_VOLATILE_REG_LOOPi;
input n; 
input initclk;
integer n;

begin
    //----------------------instruction
    $display("READ VOLATILE REGISTER INSTRUCTION LOOP STARTED");
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) 
    begin
	    if(i==0 || i==5 || i==7)    D = 1'b1;
        else        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
////        	//------------------Read VOLATILE REGISTER
  	   for(i=0;i<=(n*8)-1;i=i+1) 
    begin
        C = 1'b1;
//	    volatile_data = {volatile_data[6:0],Q};
	    #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
	    volatile_data = {volatile_data[6:0],Q};
        if (i==((n*8)-1)) C = initclk; else C = 1'b0;
	    #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
        
	end
    
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
        
		S = 1'b1;
    	#(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    	$display("%t: NOTE : Volatile Register has been read %d times!\n",$realtime, n);
    $display("%t DRIVER: Read Volatile Register Loop Instruction Ended \n =========================================================",$realtime);
    
    end	
    


endtask
/////==================================

//////========================== FAST READ IDENTIFICATION TASK ===============/////
task FAST_READ_IDi;
input n;
input[23:0] address;
input initclk;
integer j,n;
begin
	$display("%t DRIVER: Reading %d addresses of ID PAGE from address %h", $realtime, n, address);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==0)|| (i==4) || (i==6)||(i==7)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        
    end
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
	    
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
    
    for(i=0;i<=7;i=i+1)
    begin
	    
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
	    
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //----------------------read data bytes
    for(i=1;i<=n;i=i+1)
    begin
        address = U_M95XXX.memory_address;//[`MEM_ADDR_BITS-`PAGE_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            C = 1'b1;
//            read_dat = {read_dat[6:0],Q};
//$display("%t DRIVER DEBUG: from 1 to 0 | Q = %b ",$realtime, Q);
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
//$display("%t DRIVER DEBUG: from 1 to 0 | Q = %b ",$realtime, Q);
            read_dat = {read_dat[6:0],Q};
            if (i==n&&j==7) C =initclk; else C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
//$display("%t DRIVER DEBUG: from 0 to 1 ",$realtime);
        end
        $display("%t: READ RESULT: ADDRESS = [%h], DATA = [%h]\n",$realtime,address,read_dat);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Fast Read ID PAGE Instruction Ended \n =========================================================",$realtime);
    
end

endtask
//pragma protect end
task FAST_READ_ID;
input n;
input[23:0] address;
integer n;
begin
   FAST_READ_IDi(n,address,`logicbit);
end
endtask

task FAST_READ_IDh;
input n;
input[23:0] address;
integer n;
begin
   FAST_READ_IDi(n,address,1'b1);
end
endtask

/////==================================

///=====  BLOCK ERASE TASK =============//
//pragma protect 
//pragma protect begin
task BLOCK_ERASEi;
input[23:0] address_block;
input initclk;


begin

	//----------------------instruction
    $display("%t DRIVER: BLOCK ERASE INSTRUCTION STARTED",$realtime);
	   $display("%t: DRIVER : ADDRESS %b [%h h]",$realtime,address_block,address_block);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) 
    begin
	    if(i==0 || i==1 || i==3 || i==4)    D = 1'b1;
        else        D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
 
   //----------address
   for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
	    //$display("%t D = %b  ||| address_block = %b ||| i = %d ",$realtime, D, address_block, i );
        D = address_block[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    end
endtask
//pragma protect end

task BLOCK_ERASE;
input[23:0]address_block;
	
		begin
			BLOCK_ERASEi(address_block,`logicbit);
		end
endtask


task BLOCK_ERASEh;
input[23:0]address_block;
		begin
			$display(" task block_eraseh | ADDRESS = %b  %h ", address_block,address_block);
			BLOCK_ERASEi(address_block,1'b1);
			
		end
endtask
/////==================================

///===== TASK CHIP ERASE =============//
//pragma protect 
//pragma protect begin
task CHIP_ERASEi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==2)||(i==3)||(i==4))  D = 1'b0;
        else D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task CHIP_ERASE;
   CHIP_ERASEi(`logicbit);
endtask

task CHIP_ERASEh;
   CHIP_ERASEi(1'b1);
endtask
/////==================================

///===== TASK READ SFDP =============//
//pragma protect 
//pragma protect begin
task READ_SFDPi;
input n;
input[23:0] address;
input initclk;
integer j,n;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);       ///S active setup time
    for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==3)||(i==4)||(i==6)) D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
        //$display("%t DRIVER : CLOCK [%b], D [%b]",$realtime, C,D);
    end
    for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
        D = address[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
	    
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    
    
    for(i=0;i<=7;i=i+1)
    begin
	    
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
	    
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    //========================================================//
    //----------------------read data bytes
    for(i=1;i<=n;i=i+1)
    begin
        address = U_M95XXX.memory_address;//[`MEM_ADDR_BITS-`PAGE_ADDR_BITS-1:0];
        for(j=0;j<=7;j=j+1)
        begin
            C = 1'b1;
//            read_sfdp = {read_sfdp[6:0],Q};
            #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
            read_sfdp = {read_sfdp[6:0],Q};
            if (i==n&&j==7) C =initclk; else C = 1'b0;
            #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK);
        end
        $display("%t: READ_SFDP RESULT: ADDRESS = [%h], DATA = [%h]\n",$realtime,address,read_sfdp);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task READ_SFDP;
input n;
input[23:0] address;
integer n;
begin
   READ_SFDPi(n,address,`logicbit);
end
endtask

task READ_SFDPh;
input n;
input[23:0] address;
integer n;
begin
   READ_SFDPi(n,address,1'b1);
end
endtask
//////==================================
///-------TASK PAGE ERASE
//pragma protect 
//pragma protect begin
task PAGE_ERASEi;
input[23:0] address_page;
input initclk;


begin

	//----------------------instruction
    $display("%t DRIVER: PAGE ERASE INSTRUCTION STARTED",$realtime);
	   $display("%t: DRIVER : ADDRESS %b [%h h]",$realtime,address_page,address_page);
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);
    S = 1'b0;
 $display("%t DRIVER S= %b",$realtime, S );
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1) 
    begin
	    if((i==2) || (i==5))    D = 1'b0;
        else        D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
     #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
 
   //----------address
   for(i=0;i<=add_bytes*8-1;i=i+1)
    begin
	    //$display("%t D = %b  ||| address_page = %b ||| i = %d ",$realtime, D, address_page, i );
        D = address_page[add_bytes*8-1-i];
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);
        C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    //----------------------
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
	 $display("%t DRIVER S= %b",$realtime, S );
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
    $display("%t DRIVER: Page Erase Instruction Ended \n =========================================================",$realtime);
end

endtask

//pragma protect end
task PAGE_ERASE;
input[23:0]address_page;
	
		begin
			PAGE_ERASEi(address_page,`logicbit);
		end
endtask


task PAGE_ERASEh;
input[23:0]address_page;
		begin
			$display(" task page_eraseh | ADDRESS = %b  %h ", address_page,address_page);
			PAGE_ERASEi(address_page,1'b1);
			
		end
endtask
///------------------------------------

//----------------Reset_Enable Task
//pragma protect 
//pragma protect begin
task RESET_ENABLEi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==2)||(i==5)||(i==6))  D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task RESET_ENABLE;
   RESET_ENABLEi(`logicbit);
endtask

task RESET_ENABLEh;
   RESET_ENABLEi(1'b1);
endtask
/////==================================

//----------------Software_Reset Task
//pragma protect 
//pragma protect begin
task RESET_SOFTWAREi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==0)||(i==3)||(i==4)||(i==7))  D = 1'b1;
        else D = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task RESET_SOFTWARE;
   RESET_SOFTWAREi(`logicbit);
endtask

task RESET_SOFTWAREh;
   RESET_SOFTWAREi(1'b1);
endtask

//===============================================

//----------------Deep Power-Down Enter Task
//pragma protect 
//pragma protect begin
task DEEP_POWER_ENTERi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==5)||(i==6))  D = 1'b0;
        else D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task DEEP_POWER_ENTER;
   DEEP_POWER_ENTERi(`logicbit);
endtask

task DEEP_POWER_ENTERh;
   DEEP_POWER_ENTERi(1'b1);
endtask
/////==================================

//----------------Deep Power-Down Release Task
//pragma protect 
//pragma protect begin
task RELEASE_DEEP_POWERi;
input initclk;
begin
    if (C==1) C=1'b0;

    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSL);              ///S not active hold time
    S = 1'b0;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    for(i=0;i<=7;i=i+1)
    begin
        if((i==1)||(i==3)||(i==5))  D = 1'b0;
        else D = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);          //data setup time, and /S active setup time with #(M95XXX_SIM.M95XXX_Macro_mux.tSLCH-M95XXX_SIM.M95XXX_Macro_mux.tDVCH)
        C = 1'b1;
        #(M95XXX_SIM.M95XXX_Macro_mux.tH_CLK);         //Clock High Time
        if (i==7) C = initclk; else C = 1'b0;
        #(M95XXX_SIM.M95XXX_Macro_mux.tL_CLK-M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    end
    #(M95XXX_SIM.M95XXX_Macro_mux.tDVCH);
    #(M95XXX_SIM.M95XXX_Macro_mux.tCHSH);              ///S active hold time
    S = 1'b1;
    #(M95XXX_SIM.M95XXX_Macro_mux.tSHSL);              ///S Deselect time
end
endtask
//pragma protect end

task RELEASE_DEEP_POWER;
   RELEASE_DEEP_POWERi(`logicbit);
endtask

task RELEASE_DEEP_POWERh;
   RELEASE_DEEP_POWERi(1'b1);
endtask

//===============================================
endmodule


