****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  TSV79X Eldo macromodel subckt 
***
***   December 2020 (Version 1.0)
****                      
****** CONNECTIONS: 
****                  NON-INVERTING INPUT
****                    |  INVERTING INPUT
****                    |   |     POSITIVE POWER SUPPLY
****                    |   |      |      NEGATIVE POWER SUPPLY
****                    |   |      |       |     OUTPUT  
****                    |   |      |       |      |     
****                    |   |      |       |      |    
.SUBCKT TSV79X         VP  VM    VCCP    VCCN     VS
    LOUT VZOUT 0 {LOUT}
    FIOUT 0 VZOUT VREADIO 1.0
    M_NMOS1 VO_DIFF_PLUS NET0283 VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    VPROT_IN_M_VCCP NET434 NET269 DC {V_DPROT}
    VPROT_IN_P_VCCN NET262 NET263 DC {V_DPROT}
    V_OUTVLIM_HIGH NET285 NET261 DC {VD_COMPENSAZIONE}
    VPROT_IN_M_VCCN NET258 NET448 DC {V_DPROT}
    V_OUTVLIM_LOW NET256 NET257 DC {VD_COMPENSAZIONE}
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE}
    VD_DN2 NET0249 0 DC 100.0m
    VREADIO NET0150 VS DC 0
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE}
    VPROT_IN_P_VCCP NET246 NET279 DC {V_DPROT}
    VOS NET0283 NET0319 DC 0
    V56 NET0280 NET0254 DC {VD_COMPENSAZIONE}
    V57 NET0242 NET0244 DC {VD_COMPENSAZIONE}
    VD_DN1 NET0247 0 DC 100.0m
    D_OUTVLIM_HIGH VB_3 NET285 DIODE_NOVd
    DPROT_IN_P_VCCN NET262 NET0283 DIODE_VLIM
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    DPROT_IN_P_VCCP NET0283 NET279 DIODE_VLIM
    D_OUTVLIM_LOW NET257 VB_3 DIODE_NOVd
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    DPROT_IN_M_VCCN NET258 VM DIODE_VLIM
    DPROT_IN_M_VCCP VM NET269 DIODE_VLIM
    DN1 NET0247 VN_PLUS DN
    DN2 NET0249 VN_MINUS DN
    D28 VB NET0280 DIODE_NOVd
    D29 NET0244 VB DIODE_NOVd
    CCOMP VB VB_2 {CCOMP}
    COUT NET427 0 {COUT}
    CIN_DIFF VM VP {CIN_DIFF}
    CIN_CM_VP VP VREF {CIN_CM_VP}
    CIN_CM_VM VM VREF {CIN_CM_VM}
    COUT2 VZOUT 0 {COUT2}
    CZOUT_IOUT_COEFF VZOUT_IOUT_COEFF 0 1n
    E_ICC_VALUE ICC_VALUE 0 POLY(1) VCCP VCCN -0.019022260632980664
+0.031150916141692755 -0.016025920406198907 0.004088607418181006
+-5.173089707065432E-4 2.5970575472625167E-5
    E_C_VCC V_VALUES_C_R02_1_VS_VCC 0 VALUE={TABLE( V(Vccp,Vccn), +2.2 , 
+ 1f , +3.3 , 20p , +5 , 20p)/CAP_scale__C_Ro2_1_vs_VCC }
    E0 VOH_NORL 0 VALUE={0}
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ -341.09664 +
+26.9671505*V(Vccp,Vccn) -5.729564553*V(Vccp,Vccn)*V(Vccp,Vccn)
+-5000*I(VreadIo)}
    E1_REF NET410 0 VCCP 0 1.0
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_sink_filtered))}
    E_VOL_NORL VOL_NORL 0 VALUE={0}
    E_VREF VREF 0 NET444 0 1.0
    E2_REF NET450 0 VCCN 0 1.0
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={IF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E64 ALPHA_DESAT_TIME 0 VALUE={0.5}
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_source_filtered))}
    EVLIM_LOW_VOUT NET256 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo) +
+V(VOL_noRL) }
    EVLIM_HIGH_VOUT NET261 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo) -
+V(VOH_noRL) }
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ 264.836134454 +
+30.80596*V(Vccp,Vccn) -4.774637*V(Vccp,Vccn)*V(Vccp,Vccn)
+-5000*I(VreadIo)}
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={IF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    E_RO1_VOH RO1_VOH 0 POLY(1) VCCP VCCN 1.012605 22.717723453 -3.3040489
    EN NET0319 VP VN_PLUS VN_MINUS 1.0
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E58 VB_2_VREF 0 VB_2 VREF 1.0
    E_READIO V_IO_VAL 0 VALUE={I(VreadIo)}
    E_ICCSAT_LOW ICC_OUT_LOW 0 VALUE={0}
    E_RO1_VOL RO1_VOL 0 POLY(1) VCCP VCCN 18.44117647 11.9385026738
+-2.0053476
    E_ICCSAT_HIGH ICC_OUT_HIGH 0 VALUE={0}
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VOUT_DIFF 0 1
    EZOUT VB_3 NET0150
+VALUE={V(VZout)*V(VZout_Iout_coeff)*V(VZout_Vcc_coeff)}
    EZOUT_IOUT_COEFF NET310 0 VALUE={IF( I(VreadIo)>=0 , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__source)) ) , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__sink)) ) )}
    EZOUT_VCC_COEFF VZOUT_VCC_COEFF 0 POLY(1) VCCP VCCN 0.1 0.102078
+0.0155844156
    E62 NET0254 0 VALUE={V(Vref) + V(alpha_desat_time)*V(Vccp,Vccn) }
    E60 NET0242 0 VALUE={V(Vref) - V(alpha_desat_time)*V(Vccp,Vccn) } 
    R_R1 VB VREF R_NO_NOISE {R1} 
    RPROT_IN_P_VCCN NET263 VCCN R_NO_NOISE 15K 
    R2_REF NET444 NET450 R_NO_NOISE 1Meg 
    RPROT_IN_M_VCCN VCCN NET448 R_NO_NOISE 15K 
    R_ICCSAT_HIGH ICC_OUT_HIGH 0 R_NO_NOISE 1K 
    R1_REF NET410 NET444 R_NO_NOISE 1Meg 
    RIN_CM_VM VREF VM R_NO_NOISE {RIN_CM_VM} 
    RD2 VCCP_ENHANCED VO_DIFF_MINUS R_NO_NOISE {RD} 
    RD1 VCCP_ENHANCED VO_DIFF_PLUS R_NO_NOISE {RD} 
    RN2 VN_MINUS 0 R_NOISE {RN}
    RO2_1 VB_2 VREF R_NO_NOISE {RO2_1} 
    RPROT_IN_M_VCCP VCCP NET434 R_NO_NOISE 100 
    RPROT_IN_P_VCCP NET246 VCCP R_NO_NOISE 100 
    RO2_2 VB_3 VB_2 R_NO_NOISE {RO2_2} 
    R_ICCSAT_LOW ICC_OUT_LOW 0 R_NO_NOISE 1K 
    ROUT NET427 VZOUT R_NO_NOISE {ROUT} 
    RIN_DIFF VP VM R_NO_NOISE {RIN_DIFF} 
    RIN_CM_VP VREF VP R_NO_NOISE {RIN_CM_VP} 
    RZOUT_IOUT_COEFF VZOUT_IOUT_COEFF NET310 R_NO_NOISE 50 
    RN1 VN_PLUS 0 R_NOISE {RN}
    G_IIB_VM VM VREF POLY(1) VCCP VCCN -4.1596638655462225E-13
+7.696715049656223E-13 -5.729564553093961E-14
    G_ICC VCCP VCCN VALUE={IF(V(Vccp,Vccn)<=1.0 , (0.0-IEE) ,
+V(Icc_value) )}
    G_IOUT_SINKED VCCN 0 VALUE={IF(I(VreadIo)>0, 0, I(VreadIo))}
    G_IIB_VP VP VREF POLY(1) VCCP VCCN -4.1596638655462225E-13
+7.696715049656223E-13 -5.729564553093961E-14
    G_ICCSAT_OUTHIGH VCCP VCCN VALUE={IF(I(V_OUTVLIM_HIGH)>1u ,
+V(Icc_out_high), 0)}
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD}
    G_IOUT_SOURCED VCCP 0 VALUE={IF(I(VreadIo)>0, I(VreadIo),0)}
    G_I_IO VB_2 VREF VALUE={V(VB_Vref)*GB*( 1.0*( 1 -
+exp(-abs(V(v_Io_val))/2m )) )  }
    G_I_VB VB_2 VREF VB_VREF 0 {GB}
    G_ICCSAT_OUTLOW VCCP VCCN VALUE={IF(I(V_OUTVLIM_LOW)>1u ,
+V(Icc_out_low) , 0)}
X_C_R02_1_VS_VCC V_VALUES_C_R02_1_VS_VCC 0 VB_2 VREF VCCAP_PSPICE
+ PARAMS: CAP_scale={CAP_SCALE__C_RO2_1_VS_VCC} Rserie=1

    
*******************************************************************************
*
* MODELS/SUBCKTS and PARAMS used by TSV79X subckt:
*
.PARAM VCC_MIN=1.5
.PARAM RINCM=2.6843E+11
.PARAM CINCM=1.6E-12
.PARAM RIN_CM_VM={2*RINCM}
.PARAM RIN_CM_VP={2*RINCM}
.PARAM CIN_CM_VM={CINCM/2}
.PARAM CIN_CM_VP={CINCM/2}
.PARAM RINDIFF=2.6843E+11
.PARAM CINDIFF=6.3E-12
.PARAM RIN_DIFF={(2*RINCM*RINDIFF)/(2*RINCM - RINDIFF)}
.PARAM CIN_DIFF={CINDIFF - CINCM/2}
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m
.PARAM GB=29.6m
.PARAM Ro = 5.6278E+03
.PARAM A0 = 6.5e6
.PARAM Ccomp=10p
.PARAM IEE=300u
.PARAM W=67u
.PARAM L=1u
.PARAM gm_mos=3.1718E-03
.PARAM Lout  = 0.03u
.PARAM Rout  = 50
.PARAM Cout  = 0.5n
.PARAM Cout2 = 4p
.PARAM Zout_Iout_coeff_MIN= 1.0
.PARAM Iout_dc_tau__source = 0.1m
.PARAM Iout_dc_tau__sink   = 0.1m
.PARAM Ro2_2=1e-3
.PARAM Ro2_1={ Ro - Ro2_2}
.PARAM R1={A0/(gm_mos*GB*Ro2_1)}
.PARAM V_DPROT=150m
.PARAM Vd_compensazione=-788.4u
.PARAM RN=0.49k
.MODEL DN D AF=1 KF=7.0e-7
.PARAM CAP_scale__C_Ro2_1_vs_VCC=10p

.MODEL R_NO_NOISE RES T_ABS=-273
.MODEL R_NOISE    RES T_ABS=+27
.MODEL MOS_N  NMOS LEVEL=1  VTO=+0.65  KP=500E-6  T_ABS=+27
.MODEL DIODE_NOVd D LEVEL=1  IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1  IS=0.8E-15
.MODEL DIODE_ILIM D LEVEL=1  IS=0.8E-15
*
*******************************************************************************

.ENDS TSV79X
*** End of subcircuit definition.


.SUBCKT VCCAP_PSPICE Vctrl_plus Vctrl_minus Vout_plus Vout_minus  PARAMS: CAP_scale=1u  Rserie=1.0
EVin 2 0 VALUE={1/V(Vctrl_plus,Vctrl_minus)}
EV2 8 Vout_plus POLY(2) 6 0 2 0 0 0 0 0 1 0 0 0 0 0
RR1 8 Vout_minus {Rserie}
GI1 0 6 Vout_minus 8 {1/Rserie}
RR2 0 6 100G
CC1 6 0 {CAP_scale}
.ENDS VCCAP_PSPICE


