****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  TSV711 Spice macromodel subckt 
***
***   October 2013
****                      
************ CONNECTIONS: 
****                  NON-INVERTING INPUT
****                    |  INVERTING INPUT
****                    |   |     POSITIVE POWER SUPPLY
****                    |   |      |      NEGATIVE POWER SUPPLY
****                    |   |      |       |     OUTPUT  
****                    |   |      |       |      |     
****                    |   |      |       |      |  
.SUBCKT TSV711   VP  VM  VCCP VCCN  VS
    LOUT VZOUT 0 {LOUT}
    FIOUT 0 VZOUT VREADIO 1.0
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    M_NMOS1 VO_DIFF_PLUS NET229 VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    VREADI_R1 VB NET367 DC 0
    VVLIM_LOW_VB NET227 NET228 DC -770m
    VOS NET229 VP DC 0
    VPROT_IN_P_VCCP NET231 NET264 DC {V_DPROT}
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE}
    VREADIO NET0300 VS DC 0
    VVLIM_HIGH_VB NET252 NET238 DC -770m
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE}
    V_OUTVLIM_LOW NET241 NET242 DC {VD_COMPENSAZIONE}
    VPROT_IN_M_VCCN NET243 NET425 DC {V_DPROT}
    V_OUTVLIM_HIGH NET270 NET246 DC {VD_COMPENSAZIONE}
    VPROT_IN_P_VCCN NET247 NET248 DC {V_DPROT}
    VPROT_IN_M_VCCP NET411 NET254 DC {V_DPROT}
    DVLIM_HIGH_VB VB NET252 DIODE_VLIM
    DPROT_IN_M_VCCP VM NET254 DIODE_VLIM
    DVLIM_LOW_VB NET228 VB DIODE_VLIM
    DPROT_IN_M_VCCN NET243 VM DIODE_VLIM
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    D_OUTVLIM_LOW NET242 VB_3 DIODE_NOVd
    DPROT_IN_P_VCCP NET229 NET264 DIODE_VLIM
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    DPROT_IN_P_VCCN NET247 NET229 DIODE_VLIM
    D_OUTVLIM_HIGH VB_3 NET270 DIODE_NOVd
    CZOUT_IOUT_COEFF VZOUT_IOUT_COEFF 0 1n
    COUT2 VZOUT 0 {COUT2}
    CIN_CM_VM VM VREF {CIN_CM_VM}
    CIN_CM_VP VP VREF {CIN_CM_VP}
    CIN_DIFF VM VP {CIN_DIFF}
    C_RO2_1 VB_2 VREF 100p
    COUT NET404 0 {COUT}
    CDIFF_PARASITIC VO_DIFF_PLUS VO_DIFF_MINUS 270p
    CCOMP VB VB_2 {CCOMP}
    EZOUT_VCC_COEFF VZOUT_VCC_COEFF 0 POLY(1) VCCP VCCN 1.9898897058823524
+-0.096875 -0.02022058823529411
    EZOUT_IOUT_COEFF NET295 0 VALUE={IF( I(VreadIo)>=0 , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__source)) ) , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__sink)) ) )}
    EZOUT VB_3 NET0300
+VALUE={V(VZout)*V(VZout_Iout_coeff)*V(VZout_Vcc_coeff)}
    E_ICCSAT_HIGH ICC_OUT_HIGH 0 POLY(1) VCCP VCCN 0
    E_RO1_VOL RO1_VOL 0 POLY(1) VCCP VCCN 113.44485294117663
+-51.54738562091519 10.31794662309373 -0.7012527233115518
    E_ICCSAT_LOW ICC_OUT_LOW 0 POLY(1) VCCP VCCN -5.948529411764708E-6
+8.20833333333334E-6 -5.637254901960795E-7
    E_READIO V_IO_VAL 0 VALUE={I(VreadIo)}
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E_RO1_VOH RO1_VOH 0 POLY(1) VCCP VCCN 168.70680147058854
+-76.77369281045773 14.837792755991346 -0.9582652505446686
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={IF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ ( -93.33088235294122 +
+75.2083333333334*V(Vccp,Vccn) -2.328431372549031*PWR(V(Vccp,Vccn),2) ) 
+-5000*I(VreadIo)}
    EVLIM_HIGH_VOUT NET246 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo)}
    EVLIM_LOW_VOUT NET241 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo)}
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_source_filtered))}
    EVLIM_HIGH_VB NET238 0 VCCP 0 1.0
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ ( 88.5147058823529
+-87.08333333333337*V(Vccp,Vccn) + 2.6960784313725568*PWR(V(Vccp,Vccn),2)
+) -5000*I(VreadIo)}
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={IF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E_R1 NET367 VREF VALUE={I(VreadI_R1)*( R1_sink
++(R1_source-R1_sink)*1/(1+exp(-alpha_switch*(V(v_Io_val)-Io_val_switch) )
+)) }
    EVLIM_LOW_VB NET227 0 VCCN 0 1.0
    E2_REF NET427 0 VCCN 0 1.0
    E_VREF VREF 0 NET421 0 1.0
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={IF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_sink_filtered))}
    E1_REF NET387 0 VCCP 0 1.0
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VALUE={V(Vout_diff)*(
+0.7406249999999998 -0.02104166666666665*V(Vccp,Vccn) +
+0.014583333333333334*PWR(V(Vccp,Vccn),2) )}
    RZOUT_IOUT_COEFF VZOUT_IOUT_COEFF NET295 50
    RIN_CM_VP VREF VP {RIN_CM_VP}
    RIN_DIFF VP VM {RIN_DIFF}
    ROUT NET404 VZOUT {ROUT}
    R_ICCSAT_LOW ICC_OUT_LOW 0 1K
    RO2_2 VB_3 VB_2 {RO2_2}
    RPROT_IN_P_VCCP NET231 VCCP 100
    RPROT_IN_M_VCCP VCCP NET411 100
    RO2_1 VB_2 VREF {RO2_1}
    RD1 VCCP_ENHANCED VO_DIFF_PLUS {RD}
    RD2 VCCP_ENHANCED VO_DIFF_MINUS {RD}
    RIN_CM_VM VREF VM {RIN_CM_VM}
    R1_REF NET387 NET421 1Meg
    R_ICCSAT_HIGH ICC_OUT_HIGH 0 1K
    RPROT_IN_M_VCCN VCCN NET425 15K
    R2_REF NET421 NET427 1Meg
    RPROT_IN_P_VCCN NET248 VCCN 15K
    G_ICCSAT_OUTLOW VCCP VCCN VALUE={IF(I(V_OUTVLIM_LOW)>1u ,
+V(Icc_out_low) , 0)}
    G_I_VB VB_2 VREF VB_VREF 0 {GB}
    G_I_IO VB_2 VREF VALUE={V(VB_Vref)*GB*( 2*( 1 -
+exp(-abs(V(v_Io_val))/3m )) )  }
    G_IOUT_SOURCED VCCP 0 VALUE={IF(I(VreadIo)>0, I(VreadIo),0)}
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD}
    G_IIB_VM VREF VM VALUE={1p}
    G_ICC VCCP VCCN POLY(1) VCCP VCCN 7.771575630252083E-6
+9.571778711484804E-7 -4.0161064425771053E-7 5.602240896358624E-8
    G_ICCSAT_OUTHIGH VCCP VCCN VALUE={IF(I(V_OUTVLIM_HIGH)>1u ,
+V(Icc_out_high), 0)}
    G_IIB_VP VREF VP VALUE={1p}
    G_IOUT_SINKED VCCN 0 VALUE={IF(I(VreadIo)>0, 0, I(VreadIo))}

    
*******************************************************************************
*
* MODELS/SUBCKTS and PARAMS used by TSV711 subckt:
*
.PARAM VCC_MIN=1.0
.PARAM RINCM=5.4959E+10
.PARAM CINCM=3.9597E-12  
.PARAM RIN_CM_VM={2*RINCM}
.PARAM RIN_CM_VP={2*RINCM}
.PARAM CIN_CM_VM={CINCM/2}
.PARAM CIN_CM_VP={CINCM/2}
.PARAM RINDIFF=7.7132E+10
.PARAM CINDIFF=2.7050E-12
.PARAM RIN_DIFF={(2*RINCM*RINDIFF)/(2*RINCM - RINDIFF)}  
.PARAM CIN_DIFF={CINDIFF - CINCM/2}
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m 
.PARAM GB=58m 
.PARAM Ro = 3.5758e+6
.PARAM A0_source = 4.9841e+10
.PARAM A0_sink = 2e+8
.PARAM alpha_switch = 1e6
.PARAM Io_val_switch = -7u
.PARAM Ccomp=8p
.PARAM IEE=0.48u
.PARAM W=0.24u
.PARAM L=1u
.PARAM gm_mos=7.5957E-06
.PARAM Lout  = 10m
.PARAM Rout  = 5600
.PARAM Cout  = 5n
.PARAM Cout2 = 2p
.PARAM Zout_Iout_coeff_MIN= 0.04
.PARAM Iout_dc_tau__source = 0.03m 
.PARAM Iout_dc_tau__sink   = 0.03m 
.PARAM Ro2_2=1e-3 
.PARAM Ro2_1={ Ro - Ro2_2} 
.PARAM R1_sink={A0_sink/(gm_mos*GB*Ro2_1)}
.PARAM R1_source={A0_source/(gm_mos*GB*Ro2_1)}
.PARAM V_DPROT=150m
.PARAM Vd_compensazione=-788.4u

.MODEL MOS_N  NMOS LEVEL=1  VTO=+0.65  KP=500E-6 
.MODEL DIODE_NOVd D LEVEL=1  IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1  IS=0.8E-15   
.MODEL DIODE_ILIM D LEVEL=1  IS=0.8E-15  
*
*******************************************************************************

.ENDS TSV711
*** End of subcircuit definition.


