****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  RHF1009A BOL (Beginning Of Life) PSpice macromodel subckt 
***
***  Revision 3.0 (April 2017)
****                      
************ CONNECTIONS: 
****                    REFERENCE
****                       |  
****                       |        ANODE
****                       |           |      CATHODE
****                       |           |         |   
****                       |           |         |       
****                       |           |         | 
.SUBCKT RHF1009A REFERENCE ANODE CATHODE
    XIAMP_INT VM VP NET59 VCCP VCCN RHF1009A_INTERNAL_OPAMP
    G_IREF REFERENCE ANODE VALUE={Iref*( 1.0 - 1.4m*(temp-27) )}
    DVLIM_LOW_INTVREF NET90 INT_VREF DIODE_NOVd_int_Vref_high_precision
    DVLIM_HIGH_INTVREF INT_VREF NET70 DIODE_NOVd_int_Vref_high_precision
    D_REVERSE ANODE CATHODE DIODE_VREF_SOURCE
    C0 OFF_STATE 0 1n
    C_INTVREF INT_VREF ANODE_VOLTAGE {1p}
    S_SW_OUT NET59 NET79 OFF_STATE 0  SW_OUT
    F_INTVREF INT_VREF ANODE_VOLTAGE VREAD_IKA 1.0
    FREAD_IKA 0 ANODE VREAD_IKA -1.0
    VREAD_IKA NET79 CATHODE DC 0
    V2 NET70 NET088 DC {Vd_compensazione}
    V1 ANODE_VOLTAGE NET90 DC {Vd_compensazione}
    E_LINEREG NET105 VM VALUE={ line_reg*(V(CATHODE,ANODE)-int_Vref)}
    E7 NET97 0 VALUE={IF( (V(CATHODE,ANODE)>=int_Vref) & 
+(V(REFERENCE,ANODE)<=1u) , 1 , 0)}
** PAY ATTENTION! DON'T USE to implement the power the follwing: "**" or "pow" or "pwr" or "pwrs";
** they give problem of cross-simulators compatibility:
    E_INT_VREF NET088 ANODE_VOLTAGE VALUE={ ( 1.0  -0.0u*(temp-25)  )*( 
+(int_Vref-typ_Vref)  + 2.5011719097843685 + (-3.3916677209337786E-5)*temp
++ (-7.372873701088566E-7)*temp*temp +
+(1.2500601867340472E-8)*temp*temp*temp +
+(1.4361397176507046E-11)*temp*temp*temp*temp +
+(-1.581270928998964E-12)*temp*temp*temp*temp*temp +
+(1.1950547974982876E-14)*temp*temp*temp*temp*temp*temp+
+(-2.7082666002436923E-17)*temp*temp*temp*temp*temp*temp*temp   )}
    E13 NET105 0 REFERENCE 0 1.0
    E2 VP 0 INT_VREF 0 1.0
    E1 VCCP 0 VALUE={IF( V(CATHODE)>=V(ANODE) , V(CATHODE) , V(ANODE)
+)}
    E28 ANODE_VOLTAGE 0 ANODE 0 1.0
    E0 VCCN 0 ANODE 0 1.0
    R_INTVREF INT_VREF ANODE_VOLTAGE {int_Vref/Ikmin}
    R9 NET97 OFF_STATE 50
    
****************************************************************************
*
.PARAM typ_Vref = 2.5
.PARAM int_Vref = 2.499885
.PARAM Iref = 25n
.PARAM Rka_on = 0.06 
.PARAM Ikmin = 40u
.PARAM Rout_offstate=1T
.PARAM line_reg = {-1.5m +0.5u}
.PARAM A0 = 3000000
.PARAM SR={2.5/250u}
.PARAM Cout = {100u/SR}
.PARAM Rout  = { Rka_on*A0 } 
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m
.PARAM GB=10m
.PARAM IEE=10u 
.PARAM W=0.1u
.PARAM L=1u
.PARAM gm_mos=2.2363E-05
.PARAM R1={A0/(gm_mos*GB*Rout)}
.PARAM CDB2=40p
.PARAM C_second_pole = 25p
.PARAM Vd_compensazione=0

.MODEL MOS_N  NMOS LEVEL=1  VTO=+0.65  KP=500E-6 
.MODEL DIODE_NOVd D LEVEL=1  IS=10E-15 N=0.001   T_ABS=27  
.MODEL DIODE_VLIM D LEVEL=1  IS=0.8E-15          T_ABS=27  
.MODEL DIODE_ILIM D LEVEL=1  IS=0.8E-15          T_ABS=27  
.MODEL DIODE_NOVd_int_Vref_high_precision D LEVEL=1  IS=10E-15 N=0.0001   T_ABS=27  
.MODEL DIODE_VREF_SOURCE D LEVEL=1  IS=1E-12  RS=4    T_ABS=27  
.MODEL SW_OUT  VSWITCH  VON=500.0m  VOFF=100.0m  RON={Rout_offstate}  ROFF=1m
*
****************************************************************************

.ENDS
*** End of subcircuit definition.


.SUBCKT RHF1009A_INTERNAL_OPAMP VM VP VS VCCP VCCN
    M_NMOS1 VO_DIFF_PLUS NET156 VEE_N VEE_N MOS_N L={L} W={W}
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VEE_N MOS_N L={L} W={W}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    H_SINK VDEP_SINK 0 VREADIO -38
    GIOUT VB_2 VREF VALUE={IF( V(Vccp,Vccn)>=0 , GB*V(VB,Vref) , 0 )}
    GM1 VREF VB VALUE={IF( V(Vccp,Vccn)>=0 , (1/RD)*V(Vout_diff) , 0 )}
    R1 VB VREF {R1}
    R45 VB_2 VB_3 1m
    ROUT VB_2 VREF {Rout}
    RD1 VCCP_ENHANCED VO_DIFF_PLUS {RD}
    RD2 VCCP_ENHANCED VO_DIFF_MINUS {RD}
    EVLIM_HIGH_VB NET149 0 VCCP 0 1
    EVLIM_LOW_VOUT NET152 0 VCCN 0 1.0
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E15 NET151 0 VCCP 0 1.0
    E8 VREF 0 VCCN 0 1.0
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    COUT VB_3 VREF {Cout}
    CSECOND_POLE VB VREF {C_second_pole}
    C4 VO_DIFF_MINUS VEE_N {CDB2}
    D11 VB_3 NET139 DIODE_NOVd
    DVLIM_HIGH_VB VB NET141 DIODE_NOVd
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    D_OUTVLIM_LOW NET153 VB DIODE_NOVd
    VVLIM_HIGH_VB NET141 NET149 DC {Vd_compensazione}
    V13 NET139 NET151 DC {Vd_compensazione}
    V_OUTVLIM_LOW NET152 NET153 DC {Vd_compensazione}
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_enhance}
    VOS NET156 VP DC 0
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_enhance}
    VREADIO VB_3 VS DC 0
    
****************************************************************************
*
.PARAM typ_Vref = 2.5
.PARAM int_Vref = 2.499885
.PARAM Iref = 25n
.PARAM Rka_on = 0.06 
.PARAM Ikmin = 40u
.PARAM Rout_offstate=1T
.PARAM line_reg = {-1.5m +0.5u}
.PARAM A0 = 3000000
.PARAM SR={2.5/250u}
.PARAM Cout = {100u/SR}
.PARAM Rout  = { Rka_on*A0 } 
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m
.PARAM GB=10m
.PARAM IEE=10u 
.PARAM W=0.1u
.PARAM L=1u
.PARAM gm_mos=2.2363E-05
.PARAM R1={A0/(gm_mos*GB*Rout)}
.PARAM CDB2=40p
.PARAM C_second_pole = 25p
.PARAM Vd_compensazione=0

.MODEL MOS_N  NMOS LEVEL=1  VTO=+0.65  KP=500E-6 
.MODEL DIODE_NOVd D LEVEL=1  IS=10E-15 N=0.001   T_ABS=27  
.MODEL DIODE_VLIM D LEVEL=1  IS=0.8E-15          T_ABS=27  
.MODEL DIODE_ILIM D LEVEL=1  IS=0.8E-15          T_ABS=27  
.MODEL DIODE_NOVd_int_Vref_high_precision D LEVEL=1  IS=10E-15 N=0.0001   T_ABS=27  
.MODEL DIODE_VREF_SOURCE D LEVEL=1  IS=1E-12  RS=4    T_ABS=27  
*
****************************************************************************

.ENDS
*** End of subcircuit definition.




