****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  RHF43B EOR (End Of Radiation, after 300krad) Eldo macromodel subckt 
***
***  Revision 4.0 (May 2017)
****                      
************ CONNECTIONS:
****                      NON-INVERTING INPUT
****                        |  INVERTING INPUT
****                        |    |     POSITIVE POWER SUPPLY
****                        |    |      |     NEGATIVE POWER SUPPLY
****                        |    |      |       |   OUTPUT  
****                        |    |      |       |     |     
****                        |    |      |       |     |  
.SUBCKT RHF43B_EOR VP  VM  VCCP VCCN  VS
    LOUT VZOUT 0 {LOUT}
    FIOUT 0 VZOUT VREADIO 1.0
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    M_NMOS1 VO_DIFF_PLUS NET194 VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    IIN_BIAS_VP VREF VP DC {IIBP}
    IIN_BIAS_VM VREF VM DC {IIBN}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    VD_DN1 NET0236 0 DC 100.0m
    VD_DN2 NET0238 0 DC 100.0m
    VOS NET194 NET0310 DC 0
    V_OUTVLIM_LOW NET0218 NET0219 DC {VD_COMPENSAZIONE}
    V_OUTVLIM_HIGH NET0521 NET0489 DC {VD_COMPENSAZIONE}
    VREADI_R1 VB NET0255 DC 0
    VVLIM_LOW_VB NET192 NET193 DC -770m
    VPROT_IN_P_VCCP NET196 NET229 DC {V_DPROT}
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE}
    VREADIO NET0339 VS DC 0
    VVLIM_HIGH_VB NET217 NET203 DC -770m
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE}
    VPROT_IN_M_VCCN NET208 NET360 DC {V_DPROT}
    VPROT_IN_P_VCCN NET212 NET213 DC {V_DPROT}
    VPROT_IN_M_VCCP NET348 NET219 DC {V_DPROT}
    DN1 NET0236 VN_PLUS DN
    DN2 NET0238 VN_MINUS DN
    D_OUTVLIM_HIGH VB_3 NET0521 DIODE_NOVd
    DVLIM_HIGH_VB VB NET217 DIODE_VLIM
    DPROT_IN_M_VCCP VM NET219 DIODE_VLIM
    DVLIM_LOW_VB NET193 VB DIODE_VLIM
    D_OUTVLIM_LOW NET0219 VB_3 DIODE_NOVd
    DPROT_IN_M_VCCN NET208 VM DIODE_VLIM
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    DPROT_IN_P_VCCP NET194 NET229 DIODE_VLIM
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    DPROT_IN_P_VCCN NET212 NET194 DIODE_VLIM
    CIN_CM_VP VP VREF {CIN_CM_VP}
    CIN_DIFF VM VP {CIN_DIFF}
    CIN_CM_VM VM VREF {CIN_CM_VM}
    COUT2 VZOUT 0 {COUT2}
    COUT NET0424 0 {COUT}
    CZOUT_IOUT_COEFF VZOUT_IOUT_COEFF 0 1n
    CDIFF_PARASITIC VO_DIFF_PLUS VO_DIFF_MINUS 27p
    C_RO2_1 VB_2 VREF 1n
    CCOMP VB VB_2 {CCOMP}
    EN NET0310 VP VN_PLUS VN_MINUS 1.0
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={VALIF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_sink_filtered))}
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={VALIF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_source_filtered))}
    E_VOHNORL VOHNORL 0 VALUE={21m}
    E_VOLNORL VOLNORL 0 POLY(1) VCCP VCCN 0.0173076923076923
+0.0012307692307692306
    EZOUT_IOUT_COEFF NET0305 0 VALUE={VALIF( I(VreadIo)>=0 , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__source)) ) , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__sink)) ) )}
    EZOUT VB_3 NET0339
+VALUE={V(VZout)*V(VZout_Iout_coeff)*V(VZout_Vcc_coeff)}
    E_READIO V_IO_VAL 0 VALUE={I(VreadIo)}
    E_ICCSAT_HIGH ICC_OUT_HIGH 0 POLY(1) VCCP VCCN 0.001369230769230769
+-3.076923076923084E-6
    E_R1 NET0255 VREF VALUE={I(VreadI_R1)*( R1_sink
++(R1_source-R1_sink)*1/(1+exp(-alpha_switch*(V(v_Io_val)-Io_val_switch) )
+)) }
    E_ICCSAT_LOW ICC_OUT_LOW 0 POLY(1) VCCP VCCN 4.4e-3 0
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={VALIF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ 129.5  -5000*I(VreadIo)}
    EVLIM_HIGH_VB NET203 0 VCCP 0 1.0
    EZOUT_VCC_COEFF VZOUT_VCC_COEFF 0 VALUE={1.0}
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ -154.5 -5000*I(VreadIo)}
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={VALIF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    EVLIM_LOW_VB NET192 0 VCCN 0 1.0
    E2_REF NET362 0 VCCN 0 1.0
    E_VREF VREF 0 NET356 0 1.0
    EVLIM_HIGH_VOUT NET0489 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo) -
+V(VOHnoRL)}
    E1_REF NET326 0 VCCP 0 1.0
    E_RO1_VOH RO1_VOH 0 POLY(1) VCCP VCCN 24.23076923076923
+-0.07692307692307694
    E_RO1_VOL RO1_VOL 0 POLY(1) VCCP VCCN 27.46153846153846
+-1.1538461538461542
    EVLIM_LOW_VOUT NET0218 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo) +
+V(VOLnoRL)}
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VALUE={V(Vout_diff)*(
+0.938461538461538 + 0.003846153846153853*V(Vccp,Vccn) )}
    RN1 VN_PLUS 0 R_NOISE {RN}
    RN2 VN_MINUS 0 R_NOISE {RN}
    RIN_CM_VM VREF VM R_NO_NOISE {RIN_CM_VM} NONOISE
    RIN_DIFF VP VM R_NO_NOISE {RIN_DIFF} NONOISE
    RIN_CM_VP VREF VP R_NO_NOISE {RIN_CM_VP} NONOISE
    ROUT NET0424 VZOUT R_NO_NOISE {ROUT} NONOISE
    RZOUT_IOUT_COEFF VZOUT_IOUT_COEFF NET0305 R_NO_NOISE 50 NONOISE
    R_ICCSAT_LOW ICC_OUT_LOW 0 R_NO_NOISE 1K NONOISE
    RO2_2 VB_3 VB_2 R_NO_NOISE {RO2_2} NONOISE
    RPROT_IN_P_VCCP NET196 VCCP R_NO_NOISE 10 NONOISE
    RPROT_IN_M_VCCP VCCP NET348 10
    RO2_1 VB_2 VREF R_NO_NOISE {RO2_1} NONOISE
    RD1 VCCP_ENHANCED VO_DIFF_PLUS R_NO_NOISE {RD} NONOISE
    RD2 VCCP_ENHANCED VO_DIFF_MINUS R_NO_NOISE {RD} NONOISE
    R1_REF NET326 NET356 R_NO_NOISE 1Meg NONOISE
    R_ICCSAT_HIGH ICC_OUT_HIGH 0 R_NO_NOISE 1K NONOISE
    RPROT_IN_M_VCCN VCCN NET360 R_NO_NOISE 10 NONOISE
    R2_REF NET356 NET362 R_NO_NOISE 1Meg NONOISE
    RPROT_IN_P_VCCN NET213 VCCN R_NO_NOISE 10 NONOISE
    G_ICCSAT_OUTLOW VCCP VCCN VALUE={VALIF(I(V_OUTVLIM_LOW)>1u ,
+V(Icc_out_low) , 0)}
    G_IOUT_SOURCED VCCP 0 VALUE={VALIF(I(VreadIo)>0, I(VreadIo),0)}
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD}
    G_I_VB VB_2 VREF VB_VREF 0 GB
    G_ICC VCCP VCCN POLY(1) VCCP VCCN 0.0018126153846153843
+2.2461538461538457E-5
    G_ICCSAT_OUTHIGH VCCP VCCN VALUE={VALIF(I(V_OUTVLIM_HIGH)>1u ,
+V(Icc_out_high), 0)}
    G_IOUT_SINKED VCCN 0 VALUE={VALIF(I(VreadIo)>0, 0, I(VreadIo))}
    G_I_IO VB_2 VREF VALUE={V(VB_Vref)*GB*( 1.0*( 1 -
+exp(-abs(V(v_Io_val))/5m )) )  }

*******************************************************************************
*
* MODELS/SUBCKTS and PARAMS used by RHF43B EOR subckt:
*
.PARAM VCC_MIN=1.5
.PARAM RINCM=1.4165E+09
.PARAM CINCM=3.1322E-12
.PARAM RIN_CM_VM={2*RINCM}
.PARAM RIN_CM_VP={2*RINCM}
.PARAM CIN_CM_VM={CINCM/2}
.PARAM CIN_CM_VP={CINCM/2}
.PARAM RINDIFF=1.7507E+05
.PARAM CINDIFF=9.2701E-12
.PARAM RIN_DIFF={(2*RINCM*RINDIFF)/(2*RINCM - RINDIFF)}
.PARAM CIN_DIFF={CINDIFF - CINCM/2}
.PARAM RD=1k
.PARAM Iibp=19.5n
.PARAM Iibn=24n
.PARAM VCCP_enhance=-100m
.PARAM VCCN_enhance=-700m
.PARAM GB=50m  
.PARAM Ro = 50119
.PARAM A0_source = 7943282
.PARAM A0_sink = 1.35e+5
.PARAM alpha_switch = 1e6
.PARAM Io_val_switch = -7u
.PARAM Ccomp=40p
.PARAM IEE=114u
.PARAM W=8.55u
.PARAM L=1u
.PARAM gm_mos=1.8617E-03
.PARAM Lout  = 0.5u
.PARAM Rout  = 47
.PARAM Cout  = 1.5n
.PARAM Cout2 = 15p
.PARAM Zout_Iout_coeff_MIN= 0.01
.PARAM Iout_dc_tau__source = 0.5m
.PARAM Iout_dc_tau__sink   = 0.5m
.PARAM Ro2_2=1e-3
.PARAM Ro2_1={ Ro - Ro2_2 }
.PARAM R1_sink={A0_sink/(gm_mos*GB*Ro2_1)}
.PARAM R1_source={A0_source/(gm_mos*GB*Ro2_1)}
.PARAM V_DPROT=150m
.PARAM Vd_compensazione=-788.4u

.PARAM RN=1.295e+3
.MODEL DN D AF=1 KF=0.88e-9
.MODEL R_NO_NOISE RES TMOD=-273
.MODEL R_NOISE    RES TMOD=+27

.MODEL MOS_N  NMOS LEVEL=1 MODTYPE=ELDO VTO=+0.65  KP=3.55E-3   TMOD=+27
.MODEL DIODE_NOVd D LEVEL=1 MODTYPE=ELDO IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15
.MODEL DIODE_ILIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15
*
*******************************************************************************

.ENDS
*** End of subcircuit definition.


