****************************************************************************
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
* time).
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
* validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
* SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
* Thus the macromodel is often not as exhaustive as the datasheet, its goal
* is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
* (Vcc, Temperature, etc) or even worse: outside of the device operating
* conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
****  RHF330A EOR (End Of Radiation, after 300krad) Eldo macromodel subckt
****
***   Revision 2.0 (October 2011)
****
*********** CONNECTIONS: 
****                NON-INVERTING INPUT
****                 |  INVERTING INPUT
****                 |   |   POSITIVE POWER SUPPLY
****                 |   |    |   NEGATIVE POWER SUPPLY
****                 |   |    |    |  OUTPUT  
****                 |   |    |    |   |     
****                 |   |    |    |   |  
.SUBCKT RHF330A_EOR   VP  VM  VCCP VCCN  VS
    G_IIB_VP VP VREF VALUE={29.32u}
    G5 VREF VGAIN_SECOND VGAIN VREF {R_2polo}
    G_ICC VCCP VCCN VALUE={16.93m}
    G_IIB_VM VM VREF VALUE={7.015u}
    G_IOUT_SINKED VCCN 0 VALUE={VALIF(I(VreadIo)>0, 0, I(VreadIo))}
    G_I_VIN_LIM VREF NET252 VALUE={ V(IVM_lim) }
    G_IOUT_SOURCED VCCP 0 VALUE={VALIF(I(VreadIo)>0, I(VreadIo),0)}
    RGAIN VGAIN VREF {A0*RIN_DIFF_VM}
    R10 VREF VGAIN_SECOND {1/R_2polo}
    ROUT NET0269 VB_3 {Ro}
    RIN_DIFF_VP VREF VP {RIN_DIFF_VP}
    R1_REF NET421 NET277 1Meg
    R30 VM VMM 1m
    R2_REF NET277 NET281 1Meg
    R33 IVM_LIM NET0290 1m
    RIN_DIFF_VM NET354 VP_BUFFER {RIN_DIFF_VM}
    RO2_2 VB_3 VB_2 {Ro2_2}
    E_IVM_MAX_SR_NEG IVM_MAX_SR_NEG 0 VALUE={i_vm_max_sr_neg}
    E_IVM_MAX_SR_POS IVM_MAX_SR_POS 0 VALUE={i_vm_max_sr_pos}
    E_I_VIN NET0290 0 VALUE={I(V_readIVM)}
    E46 NET0465 0 IVM_MAX_SR_POS 0 1.0
    E_BUFFER_VP VP_BUFFER 0 VP 0 1
    E_VOL VGAIN NET448 VALUE={0.927}
    EVLIM_LOW_VOUT NET461 0 VCCN 0 1.0
    E47 NET0477 0 IVM_MAX_SR_NEG 0 -1.0
    EVOUT VB_2 VREF VGAIN_SECOND VREF {1.0}
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={VALIF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E_VOH NET0228 VGAIN VALUE={0.838}
    E2_REF NET281 0 VCCN 0 1.0
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    E_VREF VREF 0 NET277 0 1.0
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={VALIF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={VALIF( abs(I(VreadIo))<1m , 0 ,
+V(val_vdep_source_filtered))}
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ 1999.5 -5000*I(VreadIo)}
    EVLIM_HIGH_VOUT NET454 0 VCCP 0 1.0
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={VALIF( abs(I(VreadIo))<1m , 0 ,
+V(val_vdep_sink_filtered))}
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ -2264.5 -5000*I(VreadIo)}
    E1_REF NET421 0 VCCP 0 1.0
    CIN_DIFF_VM VM VREF {CIN_DIFF_VM}
    CIN_DIFF_VP VP VREF {CIN_DIFF_VP}
    C_COMP VGAIN VREF {Ccomp}
    C9 NET0277 VREF {C_2polo}
    D12 NET0478 IVM_LIM DIODE_NOVd
    D_OUTVLIM_HIGH NET0228 NET444 DIODE_NOVd
    D11 IVM_LIM NET0455 DIODE_NOVd
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    D1 NET462 NET448 DIODE_NOVd
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    V_READIVM NET354 VMM DC 0
    V_OUTVLIM_HIGH NET444 NET454 DC {Vd_compensazione}
    V_READICCOMP NET252 VGAIN DC 0
    VREADIO NET0269 VS DC 0
    V14 NET0477 NET0478 DC {Vd_compensazione}
    V13 NET0455 NET0465 DC {Vd_compensazione}
    V_OUTVLIM_LOW NET461 NET462 DC {Vd_compensazione}

.PARAM CIN_DIFF_VM= 1.6366e-13
.PARAM RIN_DIFF_VM= {158.5e3/A0}
.PARAM RIN_DIFF_VP=1.9595e+5
.PARAM CIN_DIFF_VP=3.7877E-13
.PARAM A0 = 1.5e+3
.PARAM Ro = 1.04
.PARAM Ro2_2=1e-3
.PARAM Ccomp = 0.335p
.PARAM C_2polo = 1f 
.PARAM R_2polo = 1e6
.PARAM i_vm_max_sr_neg = 0.565m
.PARAM i_vm_max_sr_pos = 0.565m
.PARAM Vd_compensazione=-788.4u

.MODEL DIODE_NOVd D LEVEL=1 MODTYPE=ELDO IS=10E-15 N=0.001
.MODEL DIODE_ILIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15  

.ENDS
*** End of subcircuit definition.
*
*********************************************************************************** 
