****************************************************************************
*
* WARNING : please consider following remarks before usage
*
* 1) All models are a tradeoff between accuracy and complexity (ie. simulation
*    time).
*
* 2) Macromodels are not a substitute to breadboarding, they rather confirm the
*    validity of a design approach and help to select surrounding component values.
*
* 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
*    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
*    Thus the macromodel is often not as exhaustive as the datasheet, its goal
*    is to illustrate the main parameters of the product.
*
* 4) Data issued from macromodels used outside of its specified conditions
*    (Vcc, Temperature, etc) or even worse: outside of the device operating
*    conditions (Vcc, Vicm, etc) are not reliable in any way.
*
****************************************************************************
****
***  RHF200  BOL (Beginning Of Life) Eldo macromodel subckt 
***
***  Revision 2.0 (April 2024)
****                      
************ CONNECTIONS: 
****                GAIN SELECT 
****                 |  GAIN SELECT  
****                 |   |       POSITIVE INPUT OF AMPLIFIER 1 
****                 |   |        |           POSITIVE INPUT OF AMPLIFIER 2
****                 |   |        |            |        POSITIVE POWER SUPPLY 
****                 |   |        |            |         |     GROUND
****                 |   |        |            |         |     |    OUTPUT 1
****                 |   |        |            |         |     |     |   OUTPUT 2
****                 |   |        |            |         |     |     |     |     COMMON-MODE OUTPUT VOLTAGE INPUT PIN
****                 |   |        |            |         |     |     |     |      |
.SUBCKT RHF200      G0  G1     E1_PLUS      E2_PLUS     VCC   GND   VO1   VO2    VOCM 

XOP_DIFF G0 G1 GND GND E2_PLUS E1_PLUS GND VOCM VO2 VO1 VCC
+ RHF200EA_TOP_MACROMODEL

.ENDS RHF200
*** End of subcircuit definition.



.SUBCKT RHF200EA_TOP_MACROMODEL GSEL0 GSEL1 SUB STANDBY VINBP VINP VMINUS
+VOCM VOM VOP VPLUS
    XIAMP_DIFF IN1 IN2 VOM VOP STANDBY_N STANDBY_P SUB VOCM VMINUS VPLUS
+RHF200EA_DIFF_MACROMODEL
    XI467 NET237 NET236 VINP VINBP VOUTP VOUTM STANDBY_N STANDBY_P SUB
+VMINUS VPLUS RHF200EA_INPUT_AMPLI_MACROMODEL
    XI458 GSEL0 GSEL1 NET236 NET237 VOUTM VOUTP VMINUS VPLUS
+RHF200EA_GAIN_SELECT_MACROMODEL
*    C2 IN1 NET092 {2*0.35p}
*    C1 IN2 NET094 {2*0.35p}
*    C3 NET237 NET096 { 5*0.3p +0.1p }
*    C4 NET236 NET098 { 5*0.3p +0.1p }
    E4 STANDBY_P 0 VPLUS 0 1
    E5 STANDBY_N 0 VMINUS 0 1.0
    R0 STANDBY 0 1G
    R4 IN2 VOM 500
    R1 VOUTP IN1 500
    R3 IN1 VOP 500
    R2 VOUTM IN2 500
.ENDS RHF200EA_TOP_MACROMODEL
*** End of subcircuit definition.




.SUBCKT RHF200_AMP_DIFF_SINGLE_CHAIN VOUT_CM VS VCCN VCCP VOUT_DIFF VREF
    G_I_VB_OP VB_2 VREF VB_VREF 0 {GB_FULLYDIFF}
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD_FULLYDIFF}
    VREADIO VB_3 VS DC 0
    V_OUTVLIM_LOW NET282 NET283 DC {VD_COMPENSAZIONE_FULLYDIFF}
    V_OUTVLIM_HIGH NET297 NET285 DC {VD_COMPENSAZIONE_FULLYDIFF}
    VVLIM_LOW_VB NET278 NET279 DC -770m
    VVLIM_HIGH_VB NET289 NET277 DC -770m
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    D_OUTVLIM_LOW NET283 VB_3 DIODE_NOVd
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    D_OUTVLIM_HIGH VB_3 NET297 DIODE_NOVd
    DVLIM_HIGH_VB VB NET289 DIODE_VLIM
    DVLIM_LOW_VB NET279 VB DIODE_VLIM
    C79 VB NET298 {CCOMP_FULLYDIFF}
    C_RO2_1 NET0140 VREF 2p
    E_FULLDIFF_OUTSTAGE NET0187 VOUT_CM VB_2 VREF 1.0
    E58 VOH_NORL 0 VALUE={0}
    E_RO1_VOL RO1_VOL 0 VALUE={12}
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ -500.5  -5000*I(VreadIo)}
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E_RO1_VOH RO1_VOH 0 VALUE={43}
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={VALIF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    EVLIM_HIGH_VOUT NET285 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo)
+-V(VOH_noRL) }
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={VALIF( V(Vccp,Vccn)<VCC_MIN_FULLYDIFF
+, 0 , V(val_vdep_sink_filtered))}
    EVLIM_LOW_VOUT NET282 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo) +
+V(VOL_noRL) }
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={VALIF(
+V(Vccp,Vccn)<VCC_MIN_FULLYDIFF , 0 , V(val_vdep_source_filtered))}
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ 500.5  -5000*I(VreadIo)}
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={VALIF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E_VOL_NORL VOL_NORL 0 VALUE={0}
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VOUT_DIFF 0 1.0
    EVLIM_HIGH_VB NET277 0 VCCP 0 1.0
    EVLIM_LOW_VB NET278 0 VCCN 0 1.0
    RO_FULLYDIFF_OUTSTAGE VB_3 NET0187 {RO_FULLYDIFF}
    R_R1 VB VREF {R1_FULLYDIFF}
    R136 VB_2 NET298 {RCOMP_FULLYDIFF}
    RO2_1_OP VB_2 VREF {RO2_1_FULLYDIFF}


.PARAM VCC_MIN_FULLYDIFF=2.0
.PARAM RINCM_FULLYDIFF=2.5693E+07
.PARAM CINCM_FULLYDIFF=4.4799E-14
.PARAM RIN_CM_VM_FULLYDIFF={2*RINCM_FULLYDIFF}
.PARAM RIN_CM_VP_FULLYDIFF={2*RINCM_FULLYDIFF}
.PARAM CIN_CM_VM_FULLYDIFF={CINCM_FULLYDIFF/2}
.PARAM CIN_CM_VP_FULLYDIFF={CINCM_FULLYDIFF/2}
.PARAM RINDIFF_FULLYDIFF=6.5721E+04
.PARAM CINDIFF_FULLYDIFF=5.9864E-14
.PARAM RIN_DIFF_FULLYDIFF={(2*RINCM_FULLYDIFF*RINDIFF_FULLYDIFF)/(2*RINCM_FULLYDIFF - RINDIFF_FULLYDIFF)}
.PARAM CIN_DIFF_FULLYDIFF={CINDIFF_FULLYDIFF - CINCM_FULLYDIFF/2}
.PARAM RD_FULLYDIFF=1k
.PARAM VCCP_enhance_FULLYDIFF=150m
.PARAM VCCN_enhance_FULLYDIFF=-1100m
.PARAM GB_FULLYDIFF=102m
.PARAM Ro_FULLYDIFF = 10m
.PARAM A0_FULLYDIFF = 251188  
.PARAM Ccomp_FULLYDIFF=13.3p
.PARAM IEE_FULLYDIFF=4m 
.PARAM Rcomp_FULLYDIFF=1m
.PARAM W_FULLYDIFF=450u
.PARAM L_FULLYDIFF=1u
.PARAM gm_mos_FULLYDIFF=3.0011E-02
.PARAM Ro2_1_FULLYDIFF=10k
.PARAM R1_FULLYDIFF={A0_FULLYDIFF/(gm_mos_FULLYDIFF*GB_FULLYDIFF*Ro2_1_FULLYDIFF)}
.PARAM V_DPROT_FULLYDIFF=150m
.PARAM Vd_compensazione_FULLYDIFF=-788.4u


.MODEL MOS_N  NMOS LEVEL=1 MODTYPE=ELDO VTO=+0.65  KP=500E-6
.MODEL DIODE_NOVd D LEVEL=1 MODTYPE=ELDO IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15
.MODEL DIODE_ILIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15

.ENDS RHF200_AMP_DIFF_SINGLE_CHAIN
*** End of subcircuit definition.


.SUBCKT RHF200_AMP_DIFF VCM VM VP VS_OM VS_OP VCCN VCCP
    XI_CATENA_VS_OM VOUT_CM VS_OM VCCN VCCP VOUT_DIFF_OM VREF
+RHF200_AMP_DIFF_SINGLE_CHAIN
    XI_CATENA_VS_OP VOUT_CM NET123 VCCN VCCP VOUT_DIFF_OP VREF
+RHF200_AMP_DIFF_SINGLE_CHAIN
    IEE_N VEE_N VCCN_ENHANCED DC {IEE_FULLYDIFF}
    M_NMOS1 VO_DIFF_PLUS NET147 VEE_N VCCN_ENHANCED MOS_N L={L_FULLYDIFF}
+W={W_FULLYDIFF}
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L_FULLYDIFF}
+W={W_FULLYDIFF}
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE_FULLYDIFF}
    VPROT_IN_M_VCCN NET141 NET233 DC {V_DPROT_FULLYDIFF}
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE_FULLYDIFF}
    VREADIO NET123 VS_OP DC 0
    VPROT_IN_P_VCCP NET145 NET164 DC {V_DPROT_FULLYDIFF}
    VOS NET147 VP DC 0
    VPROT_IN_M_VCCP NET223 NET166 DC {V_DPROT_FULLYDIFF}
    VPROT_IN_P_VCCN NET153 NET154 DC {V_DPROT_FULLYDIFF}
    DPROT_IN_P_VCCN NET153 NET147 DIODE_VLIM
    DPROT_IN_M_VCCN NET141 VM DIODE_VLIM
    DPROT_IN_P_VCCP NET147 NET164 DIODE_VLIM
    DPROT_IN_M_VCCP VM NET166 DIODE_VLIM
    CIN_DIFF VM VP {CIN_DIFF_FULLYDIFF}
    CDIFF_PARASITIC NET0145 NET0144 200.0f
    CIN_CM_VM VM VREF {CIN_CM_VM_FULLYDIFF}
    CIN_CM_VP VP VREF {CIN_CM_VP_FULLYDIFF}
    E_VREF VREF 0 NET0157 0 1.0
    E1_REF NET0147 0 VCCP 0 1.0
    E61 VOUT_DIFF_OM 0 VO_DIFF_PLUS VO_DIFF_MINUS -1
    EMEAS_VOUT_DIFF VOUT_DIFF_OP 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    E2_REF NET0159 0 VCCN 0 1.0
    E59 VOUT_CM 0 VCM 0 1.0
    RPROT_IN_P_VCCP NET145 VCCP 10
    RIN_DIFF VP VM {RIN_DIFF_FULLYDIFF}
    RIN_CM_VP VREF VP {RIN_CM_VP_FULLYDIFF}
    R2_REF NET0157 NET0159 1Meg
    RPROT_IN_M_VCCP VCCP NET223 10
    RD1 VCCP_ENHANCED VO_DIFF_PLUS {RD_FULLYDIFF}
    R1_REF NET0147 NET0157 1Meg
    RD2 VCCP_ENHANCED VO_DIFF_MINUS {RD_FULLYDIFF}
    RIN_CM_VM VREF VM {RIN_CM_VM_FULLYDIFF}
    RPROT_IN_M_VCCN VCCN NET233 10
    RPROT_IN_P_VCCN NET154 VCCN 10
    G_IIB_VP VREF VP VALUE={1p}
    G_IOUT_SINKED VCCN 0 VALUE={VALIF(I(VreadIo)>0, 0, I(VreadIo))}
    G_IOUT_SOURCED VCCP 0 VALUE={VALIF(I(VreadIo)>0, I(VreadIo),0)}
    G_ICC VCCP VCCN VALUE={21m - IEE_FULLYDIFF}
    G_IIB_VM VREF VM VALUE={1p}
 

.PARAM VCC_MIN_FULLYDIFF=2.0
.PARAM RINCM_FULLYDIFF=2.5693E+07
.PARAM CINCM_FULLYDIFF=4.4799E-14
.PARAM RIN_CM_VM_FULLYDIFF={2*RINCM_FULLYDIFF}
.PARAM RIN_CM_VP_FULLYDIFF={2*RINCM_FULLYDIFF}
.PARAM CIN_CM_VM_FULLYDIFF={CINCM_FULLYDIFF/2}
.PARAM CIN_CM_VP_FULLYDIFF={CINCM_FULLYDIFF/2}
.PARAM RINDIFF_FULLYDIFF=6.5721E+04
.PARAM CINDIFF_FULLYDIFF=5.9864E-14
.PARAM RIN_DIFF_FULLYDIFF={(2*RINCM_FULLYDIFF*RINDIFF_FULLYDIFF)/(2*RINCM_FULLYDIFF - RINDIFF_FULLYDIFF)}
.PARAM CIN_DIFF_FULLYDIFF={CINDIFF_FULLYDIFF - CINCM_FULLYDIFF/2}
.PARAM RD_FULLYDIFF=1k
.PARAM VCCP_enhance_FULLYDIFF=150m
.PARAM VCCN_enhance_FULLYDIFF=-1100m
.PARAM GB_FULLYDIFF=102m
.PARAM Ro_FULLYDIFF = 10m
.PARAM A0_FULLYDIFF = 251188  
.PARAM Ccomp_FULLYDIFF=13.3p
.PARAM IEE_FULLYDIFF=4m !molto alta perche' il consumo e' molto alto e l'SR molto grande
.PARAM Rcomp_FULLYDIFF=1m
.PARAM W_FULLYDIFF=450u
.PARAM L_FULLYDIFF=1u
.PARAM gm_mos_FULLYDIFF=3.0011E-02
.PARAM Ro2_1_FULLYDIFF=10k
.PARAM R1_FULLYDIFF={A0_FULLYDIFF/(gm_mos_FULLYDIFF*GB_FULLYDIFF*Ro2_1_FULLYDIFF)}
.PARAM V_DPROT_FULLYDIFF=150m
.PARAM Vd_compensazione_FULLYDIFF=-788.4u

 
.MODEL MOS_N  NMOS LEVEL=1 MODTYPE=ELDO VTO=+0.65  KP=500E-6
.MODEL DIODE_NOVd D LEVEL=1 MODTYPE=ELDO IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15
.MODEL DIODE_ILIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15

.ENDS RHF200_AMP_DIFF
*** End of subcircuit definition.



.SUBCKT RHF200EA_DIFF_MACROMODEL IM IP OM OP STANDBY_N STANDBY_P SUB VCM
+VMINUS VPLUS
    R2 SUB 0 1G
    R1 STANDBY_N 0 1G
    R0 STANDBY_P 0 1G
    XI33 VCM IM IP OM OP VMINUS VPLUS RHF200_AMP_DIFF
.ENDS RHF200EA_DIFF_MACROMODEL
*** End of subcircuit definition.



.SUBCKT RHF200_AMP_INPUT VM VP VS VCCP VCCN
    LOUT VZOUT 0 {LOUT}
    FIOUT 0 VZOUT VREADIO 1.0
    M_NMOS2 VO_DIFF_MINUS VM VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    M_NMOS1 VO_DIFF_PLUS NET194 VEE_N VCCN_ENHANCED MOS_N L={L} W={W}
    IEE_N VEE_N VCCN_ENHANCED DC {IEE}
    VVLIM_LOW_VB NET192 NET193 DC -770m
    VOS NET194 VP DC 0
    VPROT_IN_P_VCCP NET196 NET229 DC {V_DPROT}
    V_ENHANCE_VCCN VCCN_ENHANCED VCCN DC {VCCN_ENHANCE}
    VREADIO VB_3 VS DC 0
    VVLIM_HIGH_VB NET217 NET203 DC -770m
    V_ENHANCE_VCCP VCCP_ENHANCED VCCP DC {VCCP_ENHANCE}
    V_OUTVLIM_LOW NET206 NET207 DC {VD_COMPENSAZIONE}
    VPROT_IN_M_VCCN NET208 NET360 DC {V_DPROT}
    V_OUTVLIM_HIGH NET235 NET211 DC {VD_COMPENSAZIONE}
    VPROT_IN_P_VCCN NET212 NET213 DC {V_DPROT}
    VPROT_IN_M_VCCP NET348 NET219 DC {V_DPROT}
    DILIM_SINK VB_3_SINK VB_3 DIODE_ILIM
    DVLIM_HIGH_VB VB NET217 DIODE_VLIM
    DPROT_IN_M_VCCP VM NET219 DIODE_VLIM
    DVLIM_LOW_VB NET193 VB DIODE_VLIM
    DPROT_IN_M_VCCN NET208 VM DIODE_VLIM
    D_OUTVLIM_LOW NET207 VB_3 DIODE_NOVd
    DPROT_IN_P_VCCP NET194 NET229 DIODE_VLIM
    DILIM_SOURCE VB_3 VB_3_SOURCE DIODE_ILIM
    DPROT_IN_P_VCCN NET212 NET194 DIODE_VLIM
    D_OUTVLIM_HIGH VB_3 NET235 DIODE_NOVd
    CZOUT_IOUT_COEFF VZOUT_IOUT_COEFF 0 1n
    COUT2 VZOUT 0 {COUT2}
    CIN_CM_VM VM VREF {CIN_CM_VM}
    CIN_CM_VP VP VREF {CIN_CM_VP}
    CIN_DIFF VM VP {CIN_DIFF}
    C_RO2_1 NET0257 VREF 1p
    COUT NET0410 0 {COUT}
    CDIFF_PARASITIC NET0261 NET0260 18p
    CCOMP VB NET0262 {CCOMP}
    EZOUT_VCC_COEFF VZOUT_VCC_COEFF 0 VALUE={1}
    EZOUT_IOUT_COEFF NET0295 0 VALUE={VALIF( I(VreadIo)>=0 , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__source)) ) , (
+Zout_Iout_coeff_MIN + (1.0 -
+Zout_Iout_coeff_MIN)*exp(-abs(I(VreadIo)/Iout_dc_tau__sink)) ) )}
    EZOUT NET0178 VB_3
+VALUE={V(VZout)*V(VZout_Iout_coeff)*V(VZout_Vcc_coeff)}
    E58 VOH_NORL 0 VALUE={32m}
    E_SR_VCC_MODULATION VOUT_DIFF__SR_VCC 0 VOUT_DIFF 0 1.0
    E_RO1_VOL RO1_VOL 0 VALUE={6}
    E_READIO V_IO_VAL 0 VALUE={I(VreadIo)}
    E_VDEP_SINK_1 VAL_VDEP_SINK 0 VALUE={ -500.5  -5000*I(VreadIo)}
    EILIM_SINK VB_3_SINK VDEP_SINK VB_3 0 1.0
    E_RO1_VOH RO1_VOH 0 VALUE={10}
    EMEAS_VB_VREF VB_VREF 0 VB VREF 1.0
    EMEAS_VOUT_DIFF VOUT_DIFF 0 VO_DIFF_PLUS VO_DIFF_MINUS 1.0
    E_VDEP_SOURCE_2 VAL_VDEP_SOURCE_FILTERED 0
+VALUE={VALIF(V(val_vdep_source)>=0, 0, V(val_vdep_source))}
    EVLIM_HIGH_VOUT NET211 0 VALUE={V(VCCP) - V(Ro1_Voh)*I(VreadIo)
+-V(VOH_noRL) }
    E_VDEP_SINK_3 VDEP_SINK 0 VALUE={VALIF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_sink_filtered))}
    EVLIM_LOW_VOUT NET206 0 VALUE={V(VCCN) - V(Ro1_Vol)*I(VreadIo) +
+V(VOL_noRL) }
    E_VDEP_SOURCE_3 VDEP_SOURCE 0 VALUE={VALIF( V(Vccp,Vccn)<VCC_MIN , 0 ,
+V(val_vdep_source_filtered))}
    EVLIM_HIGH_VB NET203 0 VCCP 0 1.0
    EVLIM_LOW_VB NET192 0 VCCN 0 1.0
    E_VDEP_SOURCE_1 VAL_VDEP_SOURCE 0 VALUE={ 500.5  -5000*I(VreadIo)}
    E2_REF NET362 0 VCCN 0 1.0
    E_VDEP_SINK_2 VAL_VDEP_SINK_FILTERED 0
+VALUE={VALIF(V(val_vdep_sink)<=0 , 0 , V(val_vdep_sink))}
    E_VREF VREF 0 NET356 0 1.0
    E_VOL_NORL VOL_NORL 0 VALUE={13m}
    EILIM_SOURCE VB_3_SOURCE VDEP_SOURCE VB_3 0 1.0
    E1_REF NET326 0 VCCP 0 1.0
    RZOUT_IOUT_COEFF VZOUT_IOUT_COEFF NET0295 50
    RIN_CM_VP VREF VP {RIN_CM_VP}
    RIN_DIFF VP VM {RIN_DIFF}
    R_R1 VB VREF {R1}
    ROUT NET0410 VZOUT {ROUT}
    R131 VB_2 NET0262 {RCOMP}
    RO2_2 VB_3 VB_2 {RO2_2}
    RPROT_IN_P_VCCP NET196 VCCP 10
    RPROT_IN_M_VCCP VCCP NET348 10
    RO2_1 VB_2 VREF {RO2_1}
    RD1 VCCP_ENHANCED VO_DIFF_PLUS {RD}
    RD2 VCCP_ENHANCED VO_DIFF_MINUS {RD}
    RIN_CM_VM VREF VM {RIN_CM_VM}
    R1_REF NET326 NET356 1Meg
    RPROT_IN_M_VCCN VCCN NET360 10
    R2_REF NET356 NET362 1Meg
    RPROT_IN_P_VCCN NET213 VCCN 10
    G_I_VB VB_2 VREF VB_VREF 0 {GB}
    G_I_IO VREF VREF VALUE={V(VB_Vref)*GB*( 11*( 1 -
+exp(-abs(V(v_Io_val))/6m )) )  }
    GM1 VREF VB VOUT_DIFF__SR_VCC 0 {1/RD}
    G_IIB_VM VREF VM VALUE={0.04u}
    G_IIB_VP VREF VP VALUE={0.04u}


.PARAM VCC_MIN=2.0
.PARAM RINCM=2.3098E+07
.PARAM CINCM=2.8800E-14
.PARAM RIN_CM_VM={2*RINCM}
.PARAM RIN_CM_VP={2*RINCM}
.PARAM CIN_CM_VM={CINCM/2}
.PARAM CIN_CM_VP={CINCM/2}
.PARAM RINDIFF=9.8391E+04
.PARAM CINDIFF=3.4824E-14
.PARAM RIN_DIFF={(2*RINCM*RINDIFF)/(2*RINCM - RINDIFF)}
.PARAM CIN_DIFF={CINDIFF - CINCM/2}
.PARAM RD=1k
.PARAM VCCP_enhance=150m
.PARAM VCCN_enhance=-1100m
.PARAM GB=50m
.PARAM Ro = 2.1386E+04
.PARAM A0 = 1584893  
.PARAM Ccomp=10p
.PARAM IEE=4m 
.PARAM Rcomp=12  
.PARAM W=450u
.PARAM L=1u
.PARAM gm_mos=3.0011E-02
.PARAM Lout  = 0.007u
.PARAM Rout  = 40
.PARAM Cout  = 0.1n
.PARAM Cout2 = 2p
.PARAM Zout_Iout_coeff_MIN= 1.0
.PARAM Iout_dc_tau__source = 0.9m
.PARAM Iout_dc_tau__sink   = 0.03m
.PARAM Ro2_2=1e-3
.PARAM Ro2_1={ Ro - Ro2_2}
.PARAM R1={A0/(gm_mos*GB*Ro2_1)}
.PARAM V_DPROT=150m
.PARAM Vd_compensazione=-788.4u
 
.MODEL MOS_N  NMOS LEVEL=1 MODTYPE=ELDO VTO=+0.65  KP=500E-6
.MODEL DIODE_NOVd D LEVEL=1 MODTYPE=ELDO IS=10E-15 N=0.001
.MODEL DIODE_VLIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15
.MODEL DIODE_ILIM D LEVEL=1 MODTYPE=ELDO IS=0.8E-15

.ENDS RHF200_AMP_INPUT
*** End of subcircuit definition.


.SUBCKT RHF200EA_INPUT_AMPLI_MACROMODEL IM1 IM2 IP1 IP2 OP OP2 STANDBY_N
+STANDBY_P SUB VMINUS VPLUS
    XI_OP2 IM2 IP2 OP2 NET044 NET040 RHF200_AMP_INPUT
    XI_OP1 IM1 IP1 OP NET22 NET055 RHF200_AMP_INPUT
    R0 STANDBY_N 0 1G
    R1 STANDBY_P 0 1G
    R2 SUB 0 1G
    E2 NET22 0 VPLUS 0 1
    E5 NET040 0 VMINUS 0 1
    E4 NET044 0 VPLUS 0 1
    E3 NET055 0 VMINUS 0 1
.ENDS RHF200EA_INPUT_AMPLI_MACROMODEL
*** End of subcircuit definition.


.SUBCKT RHF200BA_SWITCH_MACROMODEL A B H HB VMINUS VPLUS
    R0 VPLUS 0 1G
    R2 HB 0 1G
    R1 VMINUS 0 1G
    C0 A NET26 200.0f
    Y3 VSWITCH PIN: B A H 0  PARAM: LEVEL=1 VON=3 VOFF=500.0m RON=200
+ROFF=1G
.ENDS RHF200BA_SWITCH_MACROMODEL
*** End of subcircuit definition.


.SUBCKT RHF200BA_GAIN_R_MACROMODEL G1 G13 G13B G1B G2 G2B G4 G4B INMM INMP
+OM OP VMINUS VPLUS
    XI25 INMP NET0123 G4 G4B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI27 INMM NET0129 G2 G2B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI23 INMP NET074 G13 G13B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI24 INMP NET0270 G2 G2B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI22 INMP OP G1 G1B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI29 INMM OM G1 G1B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI26 INMM NET0159 G4 G4B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    XI28 INMM NET0261 G13 G13B VMINUS VPLUS RHF200BA_SWITCH_MACROMODEL
    R1 NET0261 OM {500/4}
    R2 NET0129 NET0261 {500/4}
    R3 NET0159 NET0129 {500/4}
    R8 OP NET074 {500/4}
    R6 NET0270 NET0123 {500/4}
    R5 NET0123 NET0102 {500/4}
    R7 NET074 NET0270 {500/4}
    R4 NET0102 NET0159 {500/4}
    C0 OP NET074 {4*1.048E-14}
    C1 NET074 NET0270 {4*1.048E-14}
    C2 NET0270 NET0123 {4*1.048E-14}
    C3 NET0123 NET0102 {4*1.048E-14}
    C4 NET0102 NET0159 {4*1.048E-14}
    C5 NET0159 NET0129 {4*1.048E-14}
    C6 NET0129 NET0261 {4*1.048E-14}
    C7 NET0261 OM {4*1.048E-14}
.ENDS RHF200BA_GAIN_R_MACROMODEL
*** End of subcircuit definition.


.SUBCKT RHF200EA_GAIN_DECODER_MACROMODEL G1 G13 G13B G1B G2 G2B G4 G4B
+GSEL0 GSEL1 SUB VMINUS VPLUS
    E4 G2 0 VALUE={VALIF((V(GSEL1)>0.4)&(V(GSEL0)<0.4) , 5 , 0)  }
    E7 G4B 0 VALUE={VALIF( V(G4)<1.75 , 5 , 0)  }
    E1 G1B 0 VALUE={VALIF( V(G1)<1.75 , 5 , 0)  }
    E6 G4 0 VALUE={VALIF((V(GSEL1)>0.4)&(V(GSEL0)>0.4) , 5 , 0)  }
    E5 G2B 0 VALUE={VALIF( V(G2)<1.75 , 5 , 0)  }
    E3 G13B 0 VALUE={VALIF( V(G13)<1.75 , 5 , 0)  }
    E2 G13 0 VALUE={VALIF((V(GSEL1)<0.4)&(V(GSEL0)>0.4) , 5 , 0)  }
    E0 G1 0 VALUE={VALIF((V(GSEL1)<0.4)&(V(GSEL0)<0.4) , 5 , 0)  }
    R2 SUB 0 1G
    R0 VPLUS 0 1G
    R1 VMINUS 0 1G
.ENDS RHF200EA_GAIN_DECODER_MACROMODEL
*** End of subcircuit definition.


.SUBCKT RHF200EA_GAIN_SELECT_MACROMODEL GSEL0 GSEL1 INMM INMP OM OP VMINUS
+VPLUS
    XI33 NET138 NET113 NET125 NET123 NET122 NET135 NET133 NET130 INMM INMP
+OM OP VMINUS VPLUS RHF200BA_GAIN_R_MACROMODEL
    XI32 NET138 NET113 NET125 NET123 NET122 NET135 NET133 NET130 GSEL0
+GSEL1 VMINUS VMINUS VPLUS RHF200EA_GAIN_DECODER_MACROMODEL
.ENDS RHF200EA_GAIN_SELECT_MACROMODEL
*** End of subcircuit definition.






