/**
  ******************************************************************************
  * @file    GPIO_IOToggle_Interrupt_Mode\main.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    19-January-2018
  * @brief   This file contains the main function for GPIO_IOToggle_Interrupt_Mode
  *          example on STM8S.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2018 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "stm8s.h"

/**
  * @addtogroup GPIO_IOToggle_Interrupt_Mode
  * @{
  */

/* Private typedef -----------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/

/* Evalboard I/Os configuration */

#define LEDS_PORT (GPIOB)
#define LED2_PIN  (GPIO_PIN_5)
#define LED3_PIN  (GPIO_PIN_4)
#define LED4_PIN  (GPIO_PIN_3)
#define LED5_PIN  (GPIO_PIN_2)
#define BUTTON_PORT (GPIOE)
#define BUTTON_PIN  (GPIO_PIN_4)

/* Private macro -------------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
void Delay (u16 nCount);

/* Private functions ---------------------------------------------------------*/
/* Public variables ---------------------------------------------------------*/
extern __IO u8 ButtonState;

/* Public functions ----------------------------------------------------------*/

/**
  * @brief Example firmware main entry point.
  * @par Parameters:
  * None
  * @retval
  * None
  */
void main(void)
{
  u8 Leds; /* Contains which LEDs to operate */

  /* Initialize LEDs in Output Push-Pull Mode */
  GPIO_Init(LEDS_PORT, LED2_PIN, GPIO_MODE_OUT_PP_LOW_FAST);
  GPIO_Init(LEDS_PORT, LED3_PIN, GPIO_MODE_OUT_PP_LOW_FAST);
  GPIO_Init(LEDS_PORT, LED4_PIN, GPIO_MODE_OUT_PP_LOW_FAST);
  GPIO_Init(LEDS_PORT, LED5_PIN, GPIO_MODE_OUT_PP_LOW_FAST);

  /* Initialize PB0 (BUTTON) in Input Floating Mode with Interrupt */
  GPIO_Init(BUTTON_PORT, BUTTON_PIN, GPIO_MODE_IN_FL_IT);

  /* Initialize the Interrupt sensitivity */
  EXTI_SetExtIntSensitivity(EXTI_PORT_GPIOE, EXTI_SENSITIVITY_FALL_ONLY);

  enableInterrupts();

  /* Toggles LEDs */

  while (1)
  {
    /* Check button status */
    if (ButtonState == (u8)0x00)
    {
      Leds = (LED2_PIN | LED5_PIN);
    }
    else
    {
      Leds = (LED3_PIN | LED4_PIN);
    }

    /* LEDs ON */
    GPIO_WriteHigh(LEDS_PORT, (GPIO_Pin_TypeDef)Leds);

    Delay((u16)120000);

    /* LEDs OFF */
    GPIO_WriteLow(LEDS_PORT, (GPIO_Pin_TypeDef)Leds);

    Delay((u16)120000);
  }
}

/**
  * @brief Delay.
  * @param[in] nCount
  * @retval
  * None
  */
void Delay(u16 nCount)
{
  /* Decrement nCount value */
  while (nCount != 0)
  {
    nCount--;
  }
}

#ifdef USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param file: pointer to the source file name
  * @param line: assert_param error line source number
  * @retval
  * None
  */
void assert_failed(u8* file, u32 line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
