/**
  ******************************************************************************
  * @file    fonts.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    19-January-2018
  * @brief   This file provides text fonts for STM32xx-EVAL's LCD driver. 
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2018 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "fonts.h"

/** @addtogroup Utilities
  * @{
  */
  
/** @addtogroup STM32_EVAL
  * @{
  */ 

/** @addtogroup Common
  * @{
  */

/** @addtogroup FONTS
  * @brief      This file includes the Fonts driver of STM32xx-EVAL boards.
  * @{
  */  

/** @defgroup FONTS_Private_Types
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Defines
  * @{
  */
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Macros
  * @{
  */
/**
  * @}
  */ 
  

/** @defgroup FONTS_Private_Variables
  * @{
  */

const uint16_t ASCII8x8_Table [] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x40,
    0xa0, 0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x24, 0x24, 0xfe, 0x48, 0xfc, 0x48, 0x48,
    0x38, 0x54, 0x50, 0x38, 0x14, 0x14, 0x54, 0x38,
    0x44, 0xa8, 0xa8, 0x50, 0x14, 0x1a, 0x2a, 0x24,
    0x10, 0x28, 0x28, 0x10, 0x74, 0x4c, 0x4c, 0x30,
    0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08,
    0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x24, 0x18, 0x3c, 0x18, 0x24, 0x00,
    0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
    0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20,
    0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18,
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x38, 0x44, 0x00, 0x04, 0x08, 0x10, 0x20, 0x7c,
    0x18, 0x24, 0x04, 0x18, 0x04, 0x04, 0x24, 0x18,
    0x04, 0x0c, 0x14, 0x24, 0x44, 0x7e, 0x04, 0x04,
    0x3c, 0x20, 0x20, 0x38, 0x04, 0x04, 0x24, 0x18,
    0x18, 0x24, 0x20, 0x38, 0x24, 0x24, 0x24, 0x18,
    0x3c, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10,
    0x18, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x18,
    0x18, 0x24, 0x24, 0x24, 0x1c, 0x04, 0x24, 0x18,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x10, 0x00,
    0x00, 0x00, 0x04, 0x18, 0x20, 0x18, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x18, 0x04, 0x18, 0x20, 0x00,
    0x18, 0x24, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10,
    0x3c, 0x42, 0x99, 0xa5, 0xa5, 0x9d, 0x42, 0x38,
    0x38, 0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44,
    0x78, 0x44, 0x44, 0x78, 0x44, 0x44, 0x44, 0x78,
    0x1c, 0x22, 0x42, 0x40, 0x40, 0x42, 0x22, 0x1c,
    0x70, 0x48, 0x44, 0x44, 0x44, 0x44, 0x48, 0x70,
    0x7c, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x7c,
    0x3c, 0x20, 0x20, 0x38, 0x20, 0x20, 0x20, 0x20,
    0x1c, 0x22, 0x42, 0x40, 0x4e, 0x42, 0x22, 0x1c,
    0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x24, 0x24, 0x18,
    0x44, 0x48, 0x50, 0x70, 0x50, 0x48, 0x48, 0x44,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
    0x82, 0xc6, 0xc6, 0xaa, 0xaa, 0xaa, 0xaa, 0x92,
    0x42, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x42,
    0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18,
    0x78, 0x44, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40,
    0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x2c, 0x1a,
    0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x42,
    0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x44, 0x38,
    0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18,
    0x44, 0x44, 0x28, 0x28, 0x28, 0x28, 0x28, 0x10,
    0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x44,
    0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42,
    0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x7c, 0x04, 0x08, 0x10, 0x10, 0x20, 0x40, 0x7c,
    0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c,
    0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04,
    0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1c,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x04, 0x1c, 0x24, 0x24, 0x1c,
    0x20, 0x20, 0x28, 0x34, 0x24, 0x24, 0x34, 0x28,
    0x00, 0x00, 0x18, 0x24, 0x20, 0x20, 0x24, 0x18,
    0x04, 0x04, 0x14, 0x2c, 0x24, 0x24, 0x2c, 0x14,
    0x00, 0x00, 0x18, 0x24, 0x3c, 0x20, 0x24, 0x18,
    0x00, 0x18, 0x10, 0x10, 0x18, 0x10, 0x10, 0x10,
    0x00, 0x18, 0x24, 0x24, 0x18, 0x04, 0x24, 0x18,
    0x20, 0x20, 0x28, 0x34, 0x24, 0x24, 0x24, 0x24,
    0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x28, 0x10,
    0x20, 0x20, 0x24, 0x28, 0x30, 0x28, 0x24, 0x24,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x00, 0xa6, 0xda, 0x92, 0x92, 0x92, 0x92,
    0x00, 0x00, 0x28, 0x34, 0x24, 0x24, 0x24, 0x24,
    0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18,
    0x00, 0x28, 0x34, 0x24, 0x38, 0x20, 0x20, 0x20,
    0x00, 0x14, 0x2c, 0x24, 0x1c, 0x04, 0x04, 0x04,
    0x00, 0x00, 0x2c, 0x30, 0x20, 0x20, 0x20, 0x20,
    0x00, 0x00, 0x18, 0x24, 0x10, 0x08, 0x24, 0x18,
    0x00, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x18,
    0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x14,
    0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10,
    0x00, 0x00, 0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0x44,
    0x00, 0x00, 0x44, 0x28, 0x10, 0x10, 0x28, 0x44,
    0x00, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x00, 0x3c, 0x04, 0x08, 0x10, 0x20, 0x3c,
    0x00, 0x08, 0x10, 0x10, 0x20, 0x10, 0x10, 0x08,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x10, 0x08, 0x08, 0x04, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x00, 0x60, 0x92, 0x0c, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


sFONT Font8x8 = {
  ASCII8x8_Table,
  8, /* Width */
  8, /* Height */
};
   
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Function_Prototypes
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Functions
  * @{
  */
    
/**
  * @}
  */
  
/**
  * @}
  */ 

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */  
/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
