;***************************************************************************
;
; WARNING : please consider following remarks before usage
;
; 1) All models are a tradeoff between accuracy and complexity (ie. simulation
;    time).
;
; 2) Macromodels are not a substitute to breadboarding, they rather confirm the
;    validity of a design approach and help to select surrounding component values.
;
; 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
;    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
;    Thus the macromodel is often not as exhaustive as the datasheet, its goal
;    is to illustrate the main parameters of the product.
;
; 4) Data issued from macromodels used outside of its specified conditions
;    (Vcc, Temperature, etc) or even worse: outside of the device operating
;    conditions (Vcc, Vicm, etc) are not reliable in any way.
;
;***************************************************************************
;***
;**  RHR64  BOL (Beginning Of Life) ADS Agilent macromodel subckt
;**
;**  Revision 1.0 (March 2018)
;***
;*********** CONNECTIONS:
;***                NON-INVERTING INPUT
;***                 |   INVERTING INPUT
;***                 |    |      POSITIVE POWER SUPPLY
;***                 |    |       |      NEGATIVE POWER SUPPLY
;***                 |    |       |       |    OUTPUT
;***                 |    |       |       |     |
;***                 |    |       |       |     |
define rhr64 ( vp vm vccp vccn vs)
L:lout vzout 0 L=lout
SDD:fiout 0 vzout I[1,0]=1.0*_c1 C[1]="vreadio"
mos_n:m_nmos2 vo_diff_minus vm vee_n vccn_enhanced Length=l Width=w Mode=1
mos_n:m_nmos1 vo_diff_plus net194 vee_n vccn_enhanced Length=l Width=w Mode=1
I_Source:iee_n vee_n vccn_enhanced Idc=iee
V_Source:vreadi_r1 vb net0258 Vdc=0
V_Source:vvlim_low_vb net192 net193 Vdc=-770m
V_Source:vos net194 vp Vdc=0
V_Source:vprot_in_p_vccp net196 net229 Vdc=v_dprot
V_Source:v_enhance_vccn vccn_enhanced vccn Vdc=vccn_enhance
V_Source:vreadio net0329 vs Vdc=0
V_Source:vvlim_high_vb net217 net203 Vdc=-770m
V_Source:v_enhance_vccp vccp_enhanced vccp Vdc=vccp_enhance
V_Source:v_outvlim_low net206 net207 Vdc=vd_compensazione
V_Source:vprot_in_m_vccn net208 net360 Vdc=v_dprot
V_Source:v_outvlim_high net235 net211 Vdc=vd_compensazione
V_Source:vprot_in_p_vccn net212 net213 Vdc=v_dprot
V_Source:vprot_in_m_vccp net348 net219 Vdc=v_dprot
diode_vlim:dvlim_high_vb vb net217 Mode=1
diode_vlim:dprot_in_m_vccp vm net219 Mode=1
diode_vlim:dvlim_low_vb net193 vb Mode=1
diode_vlim:dprot_in_m_vccn net208 vm Mode=1
diode_ilim:dilim_sink vb_3_sink vb_3 Mode=1
diode_novd:d_outvlim_low net207 vb_3 Mode=1
diode_vlim:dprot_in_p_vccp net194 net229 Mode=1
diode_ilim:dilim_source vb_3 vb_3_source Mode=1
diode_vlim:dprot_in_p_vccn net212 net194 Mode=1
diode_novd:d_outvlim_high vb_3 net235 Mode=1
C:czout_iout_coeff vzout_iout_coeff 0 C=1n
C:cout2 vzout 0 C=cout2
C:cin_cm_vm vm vref C=cin_cm_vm
C:cin_cm_vp vp vref C=cin_cm_vp
C:cin_diff vm vp C=cin_diff
C:c_ro2_1 vb_2 vref C=700.0p
C:cout net0410 0 C=cout
C:cdiff_parasitic vo_diff_plus vo_diff_minus C=30p
C:ccomp vb vb_2 C=ccomp
SDD:ezout_vcc_coeff vccp vccn vzout_vcc_coeff 0 I[1,0]=0 F[2,0]=(1.6599264705882346 + -0.0645833333333332*_v1 + -0.01348039215686276*_v1^2)-_v2
SDD:ezout_iout_coeff net0295 0 F[1,0]=( if (_c1>=0) then (zout_iout_coeff_min+(1.0-zout_iout_coeff_min)*exp(-abs(_c1/iout_dc_tau__source))) else \
      (zout_iout_coeff_min+(1.0-zout_iout_coeff_min)*exp(-abs(_c1/iout_dc_tau__sink))) endif )-_v1 \
      C[1]="vreadio"
SDD:ezout vb_3 net0329 vzout 0 vzout_iout_coeff 0 vzout_vcc_coeff 0 F[1,0]=(_v2*_v3*_v4)-_v1 \
      I[2,0]=0 I[3,0]=0 I[4,0]=0
SDD:e_iccsat_high vccp vccn icc_out_high 0 I[1,0]=0 F[2,0]=(0*_v1)-_v2
SDD:e_ro1_vol vccp vccn ro1_vol 0 I[1,0]=0 F[2,0]=(80.97794117647057 + -24.708333333333343*_v1 + 2.6225490196078454*_v1^2)-_v2
SDD:e_iccsat_low vccp vccn icc_out_low 0 I[1,0]=0 F[2,0]=(-6.574632352941173e-5 + 4.014583333333334e-5*_v1 + -1.5931372549019734e-7*_v1^2)-_v2
SDD:e_readio v_io_val 0 F[1,0]=(_c1)-_v1 C[1]="vreadio"
SDD:eilim_sink vb_3 0 vb_3_sink vdep_sink I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_ro1_voh vccp vccn ro1_voh 0 I[1,0]=0 F[2,0]=(66.87132352941175 + -6.6875*_v1 + -0.25735294117647034*_v1^2)-_v2
SDD:emeas_vb_vref vb vref vb_vref 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:emeas_vout_diff vo_diff_plus vo_diff_minus vout_diff 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_source_2 val_vdep_source_filtered 0 val_vdep_source 0 F[1,0]=( if (_v2>=0) then 0 else _v2 endif )-_v1 \
      I[2,0]=0
SDD:e_vdep_source_1 val_vdep_source 0 vccp vccn F[1,0]=((-95.20588235294117+73.33333333333336*_v2+3.921568627450974*pow(_v2,2))-5000*_c1)-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:evlim_high_vout net211 0 vccp 0 ro1_voh 0 F[1,0]=(_v2-_v3*_c1)-_v1 I[2,0]=0 I[3,0]=0 \
      C[1]="vreadio"
SDD:evlim_low_vout net206 0 vccn 0 ro1_vol 0 F[1,0]=(_v2-_v3*_c1)-_v1 I[2,0]=0 I[3,0]=0 \
      C[1]="vreadio"
SDD:e_vdep_source_3 vdep_source 0 val_vdep_source_filtered 0 F[1,0]=( if (abs(_c1)<1m) then 0 else _v2 endif )-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:evlim_high_vb vccp 0 net203 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_sink_1 val_vdep_sink 0 vccp vccn F[1,0]=((211.65808823529403-172.8125*_v2+12.316176470588244*pow(_v2,2))-5000*_c1)-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:e_vdep_sink_2 val_vdep_sink_filtered 0 val_vdep_sink 0 F[1,0]=( if (_v2<=0) then 0 else _v2 endif )-_v1 \
      I[2,0]=0
SDD:e_r1 net0258 vref v_io_val 0 F[1,0]=(_c1*(r1_sink+(r1_source-r1_sink)*1/(1+exp(-alpha_switch*(_v2-io_val_switch)))))-_v1 \
      I[2,0]=0 C[1]="vreadi_r1"
SDD:evlim_low_vb vccn 0 net192 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e2_ref vccn 0 net362 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vref net356 0 vref 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_sink_3 vdep_sink 0 val_vdep_sink_filtered 0 F[1,0]=( if (abs(_c1)<1m) then 0 else _v2 endif )-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:e1_ref vccp 0 net326 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:eilim_source vb_3 0 vb_3_source vdep_source I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_sr_vcc_modulation vout_diff__sr_vcc 0 vout_diff 0 vccp vccn F[1,0]=(_v2*(0.7286764705882351+0.1008333333333332*_v3-0.00931372549019606*pow(_v3,2)))-_v1 \
      I[2,0]=0 I[3,0]=0
R:rzout_iout_coeff vzout_iout_coeff net0295 R=50
R:rin_cm_vp vref vp R=rin_cm_vp
R:rin_diff vp vm R=1T
R:rout net0410 vzout R=rout
R:r_iccsat_low icc_out_low 0 R=1k
R:ro2_2 vb_3 vb_2 R=ro2_2
R:rprot_in_p_vccp net196 vccp R=100
R:rprot_in_m_vccp vccp net348 R=100
R:ro2_1 vb_2 vref R=ro2_1
R:rd1 vccp_enhanced vo_diff_plus R=rd
R:rd2 vccp_enhanced vo_diff_minus R=rd
R:rin_cm_vm vref vm R=rin_cm_vm
R:r1_ref net326 net356 R=1M
R:r_iccsat_high icc_out_high 0 R=1k
R:rprot_in_m_vccn vccn net360 R=15k
R:r2_ref net356 net362 R=1M
R:rprot_in_p_vccn net213 vccn R=15k
SDD:g_iccsat_outlow vccp vccn icc_out_low 0 I[1,0]=( if (_c1>1u) then _v2 else 0 endif ) I[2,0]=0 \
      C[1]="v_outvlim_low"
SDD:g_i_vb vb_vref 0 vb_2 vref I[1,0]=0 I[2,0]=gb*_v1
SDD:g_i_io vb_2 vref vb_vref 0 v_io_val 0 I[1,0]=_v2*gb*(10*(1-exp(-abs(_v3)/3m))) \
      I[2,0]=0 I[3,0]=0
SDD:g_iout_sourced vccp 0 I[1,0]=( if (_c1>0) then _c1 else 0 endif ) C[1]="vreadio"
SDD:gm1 vout_diff__sr_vcc 0 vref vb I[1,0]=0 I[2,0]=1/rd*_v1
SDD:g_iib_vm vref vm I[1,0]=1p
SDD:g_icc vccp vccn vccp vccn I[1,0]=0 I[2,0]=4.027205882352942e-5 + 3.958333333333329e-6*_v1 + -1.2254901960784258e-7*_v1^2
SDD:g_iccsat_outhigh vccp vccn icc_out_high 0 I[1,0]=( if (_c1>1u) then _v2 else 0 endif ) I[2,0]=0 \
      C[1]="v_outvlim_high"
SDD:g_iib_vp vref vp I[1,0]=1p
SDD:g_iout_sinked vccn 0 I[1,0]=( if (_c1>0) then 0 else _c1 endif ) C[1]="vreadio"
;******************************************************************************
;
; MODELS/SUBCKTS and PARAMS used by RHR64 subckt:
;
 rincm=2.0828e+11
 cincm=6.6478e-12
 rin_cm_vm=2*rincm
 rin_cm_vp=2*rincm
 cin_cm_vm=cincm/2
 cin_cm_vp=cincm/2
 cindiff=3.5657e-12
 cin_diff=cindiff-cincm/2
 rd=1k
 vccp_enhance=150m
 vccn_enhance=-1100m
 gb=141m
 ro=223872
 a0_source=5.959352977968012e+7
 a0_sink=0.6e+6
 alpha_switch=1e6
 io_val_switch=-7u
 ccomp=8.8p
 iee=3u
 w=1.59u
 l=1u
 gm_mos=4.887806568937801e-05
 lout=230u
 rout=900
 cout=2n
 cout2=3.7p
 zout_iout_coeff_min=0.04
 iout_dc_tau__source=0.9m
 iout_dc_tau__sink=0.03m
 ro2_2=1e-3
 ro2_1=ro-ro2_2
 r1_sink=a0_sink/(gm_mos*gb*ro2_1)
 r1_source=a0_source/(gm_mos*gb*ro2_1)
 v_dprot=150m
 vd_compensazione=-788.4u

model mos_n MOSFET Vto=+0.65 Kp=500e-6 NMOS=1 PMOS=0 Idsmod=1 Capmod=1 Tnom=27
model diode_novd Diode Is=10e-15 N=0.001 Nbv=0.001 Ibv=1e-10 Tnom=27 IkModel=1
model diode_vlim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1
model diode_ilim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1

;
;******************************************************************************
end rhr64
;** End of subcircuit definition.



rhr64:xiamp vp vm vccp vccn vs
