;***************************************************************************
; WARNING : please consider following remarks before usage
;
; 1) All models are a tradeoff between accuracy and complexity (ie. simulation
; time).
; 2) Macromodels are not a substitute to breadboarding, they rather confirm the
; validity of a design approach and help to select surrounding component values.
;
; 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
; SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
; Thus the macromodel is often not as exhaustive as the datasheet, its goal
; is to illustrate the main parameters of the product.
;
; 4) Data issued from macromodels used outside of its specified conditions
; (Vcc, Temperature, etc) or even worse: outside of the device operating
; conditions (Vcc, Vicm, etc) are not reliable in any way.
;
;***************************************************************************
;***
;***  RHF310A  EOR (End Of Radiation, after 300krad) ADS Agilent macromodel subckt
;***
;***  Revision 1.0 (May 2012)
;***
;********** CONNECTIONS:
;***               NON-INVERTING INPUT 
;***                |  INVERTING INPUT
;***                |   |  POSITIVE POWER SUPPLY
;***                |   |   |  NEGATIVE POWER SUPPLY
;***                |   |   |   |  OUTPUT
;***                |   |   |   |   |
;***                |   |   |   |   |
define rhf310a_eor ( vp vm vccp vccn vs)
SDD:g_iib_vp vp vref I[1,0]=4.943u
SDD:g5 vgain vref vref vgain_second I[1,0]=0 I[2,0]=r_2polo*_v1
SDD:g_icc vccp vccn I[1,0]=390u
SDD:g_iib_vm vm vref I[1,0]=0.75u
SDD:g_iout_sinked vccn 0 I[1,0]=(if (_c1>0) then 0 else _c1 endif) C[1]="vreadio"
SDD:g_i_vin_lim vref net252 ivm_lim 0 I[1,0]=_v2 I[2,0]=0
SDD:g_iout_sourced vccp 0 I[1,0]=(if (_c1>0) then _c1 else 0 endif) C[1]="vreadio"
R:rgain vgain vref R=a0*rin_diff_vm
R:r10 vref vgain_second R=1/r_2polo
R:rout net0269 vb_3 R=ro
R:rin_diff_vp vref vp R=rin_diff_vp
R:r1_ref net421 net277 R=1M
R:r30 vm vmm R=1m
R:r2_ref net277 net281 R=1M
R:r33 ivm_lim net0290 R=1m
R:rin_diff_vm net354 vp_buffer R=rin_diff_vm
R:ro2_2 vb_3 vb_2 R=ro2_2
SDD:e_ivm_max_sr_neg ivm_max_sr_neg 0 F[1,0]=(i_vm_max_sr_neg)-_v1
SDD:e_ivm_max_sr_pos ivm_max_sr_pos 0 F[1,0]=(i_vm_max_sr_pos)-_v1
SDD:e_ivm_lim net0290 0 F[1,0]=(_c1)-_v1 C[1]="v_readivm"
SDD:e46 ivm_max_sr_neg 0 net0294 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_buffer_vp vp 0 vp_buffer 0 I[1,0]=0 F[2,0]=(1*_v1)-_v2
SDD:e_vol vgain net448 F[1,0]=(0.786)-_v1
SDD:evlim_low_vout vccn 0 net461 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e47 ivm_max_sr_pos 0 net0181 0 I[1,0]=0 F[2,0]=(-1.0*_v1)-_v2
SDD:evout vgain_second vref vb_2 vref I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_sink_2 val_vdep_sink_filtered 0 val_vdep_sink 0 F[1,0]=(if (_v2<=0) then 0 else _v2 endif)-_v1 \
      I[2,0]=0
SDD:e_voh net0228 vgain F[1,0]=(0.796)-_v1
SDD:e2_ref vccn 0 net281 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:eilim_sink vb_3 0 vb_3_sink vdep_sink I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:eilim_source vb_3 0 vb_3_source vdep_source I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vref net277 0 vref 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_source_2 val_vdep_source_filtered 0 val_vdep_source 0 F[1,0]=(if (_v2>=0) then 0 else _v2 endif)-_v1 \
      I[2,0]=0
SDD:e_vdep_source_3 vdep_source 0 val_vdep_source_filtered 0 F[1,0]=(if (abs(_c1)<1m) then 0 else _v2 endif)-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:e_vdep_source_1 val_vdep_source 0 F[1,0]=(499.5-5000*_c1)-_v1 C[1]="vreadio"
SDD:evlim_high_vout vccp 0 net454 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e_vdep_sink_3 vdep_sink 0 val_vdep_sink_filtered 0 F[1,0]=(if (abs(_c1)<1m) then 0 else _v2 endif)-_v1 \
      I[2,0]=0 C[1]="vreadio"
SDD:e_vdep_sink_1 val_vdep_sink 0 F[1,0]=(-549.5-5000*_c1)-_v1 C[1]="vreadio"
SDD:e1_ref vccp 0 net421 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
C:cin_diff_vm vm vref C=cin_diff_vm
C:cin_diff_vp vp vref C=cin_diff_vp
C:c_comp vgain vref C=ccomp
;    C9 NET0277 VREF {C_2polo}
diode_novd_extra:d11 ivm_lim net0282 Mode=1
diode_novd_extra:d12 net0292 ivm_lim Mode=1
diode_novd:d_outvlim_high net0228 net444 Mode=1
diode_ilim:dilim_source vb_3 vb_3_source Mode=1
diode_novd:d1 net462 net448 Mode=1
diode_ilim:dilim_sink vb_3_sink vb_3 Mode=1
V_Source:v_readivm net354 vmm Vdc=0
V_Source:v_outvlim_high net444 net454 Vdc=vd_compensazione
V_Source:v14 net0181 net0292 Vdc=vd_compensazione_extra
V_Source:v_readiccomp net252 vgain Vdc=0
V_Source:vreadio net0269 vs Vdc=0
V_Source:v13 net0282 net0294 Vdc=vd_compensazione_extra
V_Source:v_outvlim_low net461 net462 Vdc=vd_compensazione

 cin_diff_vm=1.6366e-13
 rin_diff_vm=1044.3e3/a0
 rin_diff_vp=9.4363e+05
 cin_diff_vp=9.0617e-13
 a0=1.0e+3
 ro=3.255
 ro2_2=1e-3
 ccomp=0.3p
 c_2polo=1f
 r_2polo=1e6
 i_vm_max_sr_neg=34.1u
 i_vm_max_sr_pos=34.1u
 vd_compensazione=-788.4u
 vd_compensazione_extra=-82u

model diode_novd_extra Diode Is=10e-15 N=0.0001 Nbv=0.0001 Ibv=1e-10 Tnom=27 IkModel=1
model diode_novd Diode Is=10e-15 N=0.001 Nbv=0.001 Ibv=1e-10 Tnom=27 IkModel=1
model diode_ilim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1

end rhf310a_eor
;** End of subcircuit definition.

;
;**********************************************************************************

;rhf310a_eor:xiamp  vp vm vccp vccn vs