;***************************************************************************
;
; WARNING : please consider following remarks before usage
;
; 1) All models are a tradeoff between accuracy and complexity (ie. simulation
;    time).
;
; 2) Macromodels are not a substitute to breadboarding, they rather confirm the
;    validity of a design approach and help to select surrounding component values.
;
; 3) A macromodel emulates the NOMINAL performance of a TYPICAL device within
;    SPECIFIED OPERATING CONDITIONS (ie. temperature, supply voltage, etc.).
;    Thus the macromodel is often not as exhaustive as the datasheet, its goal
;    is to illustrate the main parameters of the product.
;
; 4) Data issued from macromodels used outside of its specified conditions
;    (Vcc, Temperature, etc) or even worse: outside of the device operating
;    conditions (Vcc, Vicm, etc) are not reliable in any way.
;
;***************************************************************************
;***
;**  RHF1009A BOL (Beginning Of Life) ADS Agilent macromodel subckt
;**
;**   Revision 3.0 (April 2017)
;***
;*********** CONNECTIONS:
;***                    REFERENCE
;***                       |
;***                       |        ANODE
;***                       |           |      CATHODE
;***                       |           |         |
;***                       |           |         |
;***                       |           |         |
define rhf1009a ( reference anode cathode)
rhf1009a_internal_opamp:xiamp_int vm vp net59 vccp vccn
SDD:g_iref reference anode I[1,0]=iref*(1.0-1.4m*(temp-27))
diode_novd_int_vref_high_precision:dvlim_low_intvref net90 int_vref Mode=1 Temp=27
diode_novd_int_vref_high_precision:dvlim_high_intvref int_vref net70 Mode=1 Temp=27
diode_vref_source:d_reverse anode cathode Mode=1 Temp=27
C:c0xE off_state 0 C=1n
C:c_intvref int_vref anode_voltage C=1p


;PSpice:
;S_SW_OUT NET59 NET79 OFF_STATE 0  SW_OUT
;.MODEL SW_OUT  VSWITCH  VON=500.0m  VOFF=100.0m  RON={Rout_offstate}  ROFF=1m
; 
;ADS:
;SKIPPED da nettrans ma aggiunto a mano:
;
"SW_OUT_MODEL":SW_OUT  net59 net79 off_state 0   R1=1e-3 Ohm V1=100e-3  R2=rout_offstate Ohm V2=500e-3 
model SW_OUT_MODEL SwitchV_Model                 R1=1e-3 Ohm V1=100e-3  R2=rout_offstate Ohm V2=500e-3 



SDD:f_intvref int_vref anode_voltage I[1,0]=1.0*_c1 C[1]="vread_ika"
SDD:fread_ika 0 anode I[1,0]=-1.0*_c1 C[1]="vread_ika"
V_Source:vread_ika net79 cathode Vdc=0
V_Source:v2 net70 net088 Vdc=vd_compensazione
V_Source:v1 anode_voltage net90 Vdc=vd_compensazione
SDD:e_linereg net105 vm cathode anode F[1,0]=(line_reg*(_v2-int_vref))-_v1 I[2,0]=0
SDD:e7 net97 0 cathode anode reference anode F[1,0]=( if ((_v2>=int_vref)&&(_v3<=1u)) then 1 else 0 endif )-_v1 \
      I[2,0]=0 I[3,0]=0
;* PAY ATTENTION! DON'T USE to implement the power the follwing: "**" or "pow" or "pwr" or "pwrs";
;* they give problem of cross-simulators compatibility:
SDD:e_int_vref net088 anode_voltage F[1,0]=((1.0-0.0u*(temp-25))*((int_vref-typ_vref)+2.5011719097843685+(-3.3916677209337786e-5)*temp+(-7.372873701088566e-7)*temp*temp+(1.2500601867340472e-8)*temp*temp*temp+(1.4361397176507046e-11)*temp*temp*temp*temp+(-1.581270928998964e-12)*temp*temp*temp*temp*temp+(1.1950547974982876e-14)*temp*temp*temp*temp*temp*temp+(-2.7082666002436923e-17)*temp*temp*temp*temp*temp*temp*temp))-_v1
SDD:e13 reference 0 net105 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e2 int_vref 0 vp 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e1 vccp 0 cathode 0 anode 0 F[1,0]=( if (_v2>=_v3) then _v2 else _v3 endif )-_v1 I[2,0]=0 I[3,0]=0
SDD:e28 anode 0 anode_voltage 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e0xE anode 0 vccn 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
R:r_intvref int_vref anode_voltage R=int_vref/ikmin
R:r9 net97 off_state R=50
;***************************************************************************
;
 typ_vref=2.5 
 int_vref=2.499885  
 iref=25n
 rka_on=0.06
 ikmin=40u
 rout_offstate=1T
 line_reg=-1.5m+0.5u
 a0=3000000
 sr=2.5/250u
 cout=100u/sr
 rout=rka_on*a0
 rd=1k
 vccp_enhance=150m
 vccn_enhance=-1100m
 gb=10m
 iee=10u
 w=0.1u
 l=1u
 gm_mos=2.2363e-05
 r1=a0/(gm_mos*gb*rout)
 cdb2=40p
 c_second_pole=25p
 vd_compensazione=0

model mos_n MOSFET Vto=+0.65 Kp=500e-6 NMOS=1 PMOS=0 Idsmod=1 Capmod=1 Tnom=27  
model diode_novd Diode Is=10e-15 N=0.001 Nbv=0.001 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_vlim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_ilim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_novd_int_vref_high_precision Diode Is=10e-15 N=0.0001 Nbv=0.0001 Ibv=1e-10 \
      Tnom=27 IkModel=1   
model diode_vref_source Diode Is=1e-12 Rs=4 Ibv=1e-10 Tnom=27 IkModel=1   

;
;***************************************************************************
end rhf1009a


;** End of subcircuit definition.
define rhf1009a_internal_opamp ( vm vp vs vccp vccn)
mos_n:m_nmos1 vo_diff_plus net156 vee_n vee_n Length=l Width=w Mode=1 
mos_n:m_nmos2 vo_diff_minus vm vee_n vee_n Length=l Width=w Mode=1 
I_Source:iee_n vee_n vccn_enhanced Idc=iee
SDD:h_sink vdep_sink 0 F[1,0]=-(-38*_c1)+_v1 C[1]="vreadio"
SDD:giout vb_2 vref vccp vccn vb vref I[1,0]=( if (_v2>=0) then gb*_v3 else 0 endif ) I[2,0]=0 I[3,0]=0
SDD:gm1 vref vb vccp vccn vout_diff 0 I[1,0]=( if (_v2>=0) then (1/rd)*_v3 else 0 endif ) I[2,0]=0 \
      I[3,0]=0
R:r1 vb vref R=r1
R:r45 vb_2 vb_3 R=1m
R:rout vb_2 vref R=rout
R:rd1 vccp_enhanced vo_diff_plus R=rd
R:rd2 vccp_enhanced vo_diff_minus R=rd
SDD:evlim_high_vb vccp 0 net149 0 I[1,0]=0 F[2,0]=(1*_v1)-_v2
SDD:evlim_low_vout vccn 0 net152 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:eilim_sink vb_3 0 vb_3_sink vdep_sink I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e15 vccp 0 net151 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:e8 vccn 0 vref 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
SDD:emeas_vout_diff vo_diff_plus vo_diff_minus vout_diff 0 I[1,0]=0 F[2,0]=(1.0*_v1)-_v2
C:cout vb_3 vref C=cout
C:csecond_pole vb vref C=c_second_pole
C:c4 vo_diff_minus vee_n C=cdb2
diode_novd:d11 vb_3 net139 Mode=1 Temp=27
diode_novd:dvlim_high_vb vb net141 Mode=1 Temp=27
diode_ilim:dilim_sink vb_3_sink vb_3 Mode=1 Temp=27
diode_novd:d_outvlim_low net153 vb Mode=1 Temp=27
V_Source:vvlim_high_vb net141 net149 Vdc=vd_compensazione
V_Source:v13 net139 net151 Vdc=vd_compensazione
V_Source:v_outvlim_low net152 net153 Vdc=vd_compensazione
V_Source:v_enhance_vccp vccp_enhanced vccp Vdc=vccp_enhance
V_Source:vos net156 vp Vdc=0
V_Source:v_enhance_vccn vccn_enhanced vccn Vdc=vccn_enhance
V_Source:vreadio vb_3 vs Vdc=0
;***************************************************************************
;
 typ_vref=2.5 
 int_vref=2.499885 
 iref=25n
 rka_on=0.06
 ikmin=40u
 rout_offstate=1T
 line_reg=-1.5m+0.5u
 a0=3000000
 sr=2.5/250u
 cout=100u/sr
 rout=rka_on*a0
 rd=1k
 vccp_enhance=150m
 vccn_enhance=-1100m
 gb=10m
 iee=10u
 w=0.1u
 l=1u
 gm_mos=2.2363e-05
 r1=a0/(gm_mos*gb*rout)
 cdb2=40p
 c_second_pole=25p
 vd_compensazione=0

model mos_n MOSFET Vto=+0.65 Kp=500e-6 NMOS=1 PMOS=0 Idsmod=1 Capmod=1 Tnom=27  
model diode_novd Diode Is=10e-15 N=0.001 Nbv=0.001 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_vlim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_ilim Diode Is=0.8e-15 Ibv=1e-10 Tnom=27 IkModel=1  
model diode_novd_int_vref_high_precision Diode Is=10e-15 N=0.0001 Nbv=0.0001 Ibv=1e-10 \
      Tnom=27 IkModel=1   
model diode_vref_source Diode Is=1e-12 Rs=4 Ibv=1e-10 Tnom=27 IkModel=1  

;
;***************************************************************************
end rhf1009a_internal_opamp




;rhf1009a:xvref reference anode  cathode



